/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import edu.colorado.phet.common.phetcommon.files.PhetInstallation;
import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import edu.colorado.phet.common.phetcommon.util.FileUtils;
import edu.colorado.phet.common.phetcommon.util.logging.USLogger;
import java.net.URL;

public class DeploymentScenario {
    public static final DeploymentScenario PHET_INSTALLATION = new DeploymentScenario("phet-installation", true, true, true);
    public static final DeploymentScenario STANDALONE_JAR = new DeploymentScenario("standalone-jar", true, true, true);
    public static final DeploymentScenario PHET_PRODUCTION_WEBSITE = new DeploymentScenario("phet-production-website", false, false, false);
    public static final DeploymentScenario PHET_DEVELOPMENT_WEBSITE = new DeploymentScenario("phet-development-website", false, false, false);
    public static final DeploymentScenario OTHER_WEBSITE = new DeploymentScenario("other-website", true, true, false);
    public static final DeploymentScenario DEVELOPER_IDE = new DeploymentScenario("developer-ide", true, true, false);
    public static final DeploymentScenario UNKNOWN = new DeploymentScenario("unknown", true, true, false);
    private static DeploymentScenario instance = null;
    private final String name;
    private final boolean statisticsEnabled;
    private final boolean updatesEnabled;
    private final boolean updatable;

    private DeploymentScenario(String string, boolean bl, boolean bl2, boolean bl3) {
        this.name = string;
        this.statisticsEnabled = bl;
        this.updatesEnabled = bl2;
        this.updatable = bl3;
    }

    public boolean isUpdatesEnabled() {
        return this.updatesEnabled;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DeploymentScenario) {
            bl = this.getName().equals(((DeploymentScenario)object).getName());
        }
        return bl;
    }

    public static DeploymentScenario getInstance() {
        if (instance == null) {
            instance = DeploymentScenario.determineScenario();
        }
        return instance;
    }

    private static DeploymentScenario determineScenario() {
        DeploymentScenario deploymentScenario = UNKNOWN;
        if (PhetServiceManager.isJavaWebStart()) {
            if (PhetInstallation.exists()) {
                deploymentScenario = PHET_INSTALLATION;
            } else {
                URL uRL = PhetServiceManager.getCodeBase();
                if (uRL != null) {
                    USLogger.log("DeploymentScenario codeBase=" + uRL.toString());
                    String string = uRL.getAuthority() + uRL.getPath();
                    deploymentScenario = string.startsWith("phet.colorado.edu") ? PHET_PRODUCTION_WEBSITE : (string.indexOf("colorado.edu") >= 0 ? PHET_DEVELOPMENT_WEBSITE : OTHER_WEBSITE);
                }
            }
        } else {
            deploymentScenario = FileUtils.isJarCodeSource() ? STANDALONE_JAR : DEVELOPER_IDE;
        }
        USLogger.log("DeploymentScenario.determineScenario " + deploymentScenario.getName());
        return deploymentScenario;
    }
}

