/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.dialogs;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.dialogs.ContribLicenseDialog;
import edu.colorado.phet.common.phetcommon.resources.DefaultResourceLoader;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.AnnotationParser;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class CreditsDialog
extends PaintImmediateDialog {
    private static final Dimension SCROLLPANE_SIZE = new Dimension(525, 300);
    private static final String TITLE = PhetCommonResources.getString("Common.About.CreditsDialog.Title");
    private static final String CLOSE_BUTTON = PhetCommonResources.getString("Common.choice.close");
    private static final String PHET_DEV_TEAM = PhetCommonResources.getString("Common.About.CreditsDialog.PhetDevelopmentTeam");
    private static final String THIRD_PARTY_USAGE = PhetCommonResources.getString("Common.About.CreditsDialog.UsesThirdPartySoftware");
    private static final String LEAD_DESIGN = PhetCommonResources.getString("Common.About.CreditsDialog.lead-design");
    private static final String SOFTWARE_DEVELOPMENT = PhetCommonResources.getString("Common.About.CreditsDialog.software-development");
    private static final String DESIGN_TEAM = PhetCommonResources.getString("Common.About.CreditsDialog.design-team");
    private static final String INTERVIEWS = PhetCommonResources.getString("Common.About.CreditsDialog.interviews");
    private String projectName;
    private String phetLicenseString;

    public CreditsDialog(Dialog dialog, String string) {
        super(dialog, TITLE);
        this.setModal(true);
        this.projectName = string;
        try {
            this.phetLicenseString = new DefaultResourceLoader().getResourceAsString(string + "/contrib-licenses/license-info.txt");
        }
        catch (IOException iOException) {
            System.err.println(this.getClass().getName() + ": No license info found; Perhaps you need to generate license information for this simulation, using PhetBuildGUI->Misc->Generate License Info");
        }
        String string2 = "<b>" + PHET_DEV_TEAM + "</b><br>\n" + "<br>\n" + this.getCreditsSnippet() + "<br>\n" + "<br>\n" + "<b>" + THIRD_PARTY_USAGE + "</b><br>\n" + "<br>\n" + this.getLicenseSnippet();
        String string3 = HTMLUtils.createStyledHTMLFromFragment(string2);
        InteractiveHTMLPane interactiveHTMLPane = new InteractiveHTMLPane(string3);
        JScrollPane jScrollPane = new JScrollPane(interactiveHTMLPane);
        jScrollPane.setPreferredSize(SCROLLPANE_SIZE);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(CLOSE_BUTTON);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreditsDialog.this.setVisible(false);
                CreditsDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        this.pack();
        SwingUtils.centerDialogInParent(this);
        interactiveHTMLPane.setCaretPosition(0);
    }

    private void displayLicenseForID(String string) {
        String string2 = this.getLicenseText(string);
        if (!string2.trim().startsWith("<html")) {
            string2 = HTMLUtils.createStyledHTMLFromFragment(string2);
            string2 = string2.replaceAll("\\n", "<br>");
        }
        ContribLicenseDialog contribLicenseDialog = new ContribLicenseDialog((Dialog)this, "License Details", string2);
        contribLicenseDialog.setVisible(true);
    }

    private String getLicenseSnippet() {
        if (this.phetLicenseString == null) {
            return "No license info found.";
        }
        AnnotationParser.Annotation[] annotationArray = AnnotationParser.getAnnotations(this.phetLicenseString);
        String string = "";
        for (int i = 0; i < annotationArray.length; ++i) {
            String string2 = annotationArray[i].getId();
            String string3 = annotationArray[i].get("name");
            String string4 = annotationArray[i].get("description");
            String string5 = annotationArray[i].get("copyright");
            String string6 = annotationArray[i].get("website");
            string = string + string3 + ", " + string4 + "<br>";
            string = string + "&copy;&nbsp;" + string5 + " - " + string6 + "<br>";
            string = annotationArray[i].get("license") != null ? string + "<a href=\"http://" + string2 + "\">" + annotationArray[i].get("license") + "<a>" : string + "license not found";
            string = string + "<br><br>";
        }
        return string;
    }

    private String getCreditsSnippet() {
        String string = "";
        try {
            string = new DefaultResourceLoader().getResourceAsString(this.projectName + "/credits.txt");
        }
        catch (IOException iOException) {
            System.err.println(this.getClass().getName() + "Sim was missing credits information.");
        }
        if (string.trim().length() == 0) {
            return "No credits found.";
        }
        AnnotationParser.Annotation annotation = AnnotationParser.parse(string);
        HashMap hashMap = annotation.getMap();
        ArrayList arrayList = annotation.getKeyOrdering();
        String string2 = "";
        for (String string3 : arrayList) {
            String string4 = (String)hashMap.get(string3);
            string2 = string2 + this.translate(string3, string4) + "<br>";
        }
        return string2;
    }

    private String translate(String string, String string2) {
        if (string.equals("lead-design")) {
            return LEAD_DESIGN + ": " + string2;
        }
        if (string.equals("software-development")) {
            return SOFTWARE_DEVELOPMENT + ": " + string2;
        }
        if (string.equals("design-team")) {
            return DESIGN_TEAM + ": " + string2;
        }
        if (string.equals("interviews")) {
            return INTERVIEWS + ": " + string2;
        }
        return string2;
    }

    public String getLicenseText(String string) {
        try {
            AnnotationParser.Annotation annotation = this.getAnnotation(string);
            return new DefaultResourceLoader().getResourceAsString(this.projectName + "/contrib-licenses/" + string + "-" + annotation.get("licensefile"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "license not found";
        }
    }

    private AnnotationParser.Annotation getAnnotation(String string) {
        AnnotationParser.Annotation[] annotationArray = AnnotationParser.getAnnotations(this.phetLicenseString);
        AnnotationParser.Annotation annotation = null;
        for (int i = 0; i < annotationArray.length; ++i) {
            AnnotationParser.Annotation annotation2 = annotationArray[i];
            if (!annotation2.getId().equals(string)) continue;
            annotation = annotation2;
        }
        return annotation;
    }

    public class InteractiveHTMLPane
    extends HTMLUtils.HTMLEditorPane {
        public InteractiveHTMLPane(String string) {
            super(string);
            this.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        CreditsDialog.this.displayLicenseForID(hyperlinkEvent.getURL().getHost());
                    }
                }
            });
        }
    }
}

