/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.AWTSplashWindow;
import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.statistics.StatisticsManager;
import edu.colorado.phet.common.phetcommon.updates.AutomaticUpdatesManager;
import edu.colorado.phet.common.phetcommon.updates.ManualUpdatesManager;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;

public class PhetApplicationLauncher {
    private AWTSplashWindow splashWindow;
    private Frame splashWindowOwner;

    private void showSplashWindow(String string) {
        if (this.splashWindow == null) {
            this.splashWindowOwner = new Frame();
            this.splashWindow = new AWTSplashWindow(this.splashWindowOwner, string);
            this.splashWindow.setVisible(true);
        }
    }

    private void disposeSplashWindow() {
        if (this.splashWindow != null) {
            this.splashWindow.dispose();
            this.splashWindow = null;
            this.splashWindowOwner.dispose();
            this.splashWindowOwner = null;
        }
    }

    public void launchSim(String[] stringArray, String string, Class clazz) {
        this.launchSim(stringArray, string, new ReflectionApplicationConstructor(clazz));
    }

    public void launchSim(String[] stringArray, String string, ApplicationConstructor applicationConstructor) {
        this.launchSim(new PhetApplicationConfig(stringArray, string), applicationConstructor);
    }

    public void launchSim(final PhetApplicationConfig phetApplicationConfig, final ApplicationConstructor applicationConstructor) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    phetApplicationConfig.getLookAndFeel().initLookAndFeel();
                    new JSpinner();
                    if (applicationConstructor != null) {
                        PhetApplicationLauncher.this.showSplashWindow(phetApplicationConfig.getName());
                        PhetApplication phetApplication = applicationConstructor.getApplication(phetApplicationConfig);
                        phetApplication.startApplication();
                        PhetApplicationLauncher.this.disposeSplashWindow();
                        StatisticsManager.initInstance(phetApplication).start();
                        AutomaticUpdatesManager.initInstance(phetApplication).start();
                        ManualUpdatesManager.initInstance(phetApplication);
                    } else {
                        new RuntimeException("No applicationconstructor specified").printStackTrace();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public static class ReflectionApplicationConstructor
    implements ApplicationConstructor {
        private Class phetApplicationClass;

        public ReflectionApplicationConstructor(Class clazz) {
            this.phetApplicationClass = clazz;
        }

        public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
            try {
                return (PhetApplication)this.phetApplicationClass.getConstructor(phetApplicationConfig.getClass()).newInstance(phetApplicationConfig);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

