/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols;

import edu.colorado.phet.common.phetcommon.util.MultiMap;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.bounds.Boundary;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.event.MouseInputListener;

public class MouseManager
implements MouseInputListener {
    MultiMap am;
    MouseInputListener activeUnit;

    public MouseManager(MultiMap multiMap) {
        this.am = multiMap;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.handleEntranceAndExit(mouseEvent);
        if (this.activeUnit != null) {
            this.activeUnit.mouseClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.handleEntranceAndExit(mouseEvent);
        if (this.activeUnit != null) {
            this.activeUnit.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.activeUnit != null) {
            this.activeUnit.mouseReleased(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.handleEntranceAndExit(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.handleEntranceAndExit(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.activeUnit != null) {
            this.activeUnit.mouseDragged(mouseEvent);
        }
    }

    private MouseInputListener getHandler(MouseEvent mouseEvent) {
        Iterator iterator = this.am.reverseIterator();
        while (iterator.hasNext()) {
            Boundary boundary;
            Object e = iterator.next();
            if (!(e instanceof Boundary) || !(e instanceof MouseInputListener) || !(boundary = (Boundary)e).contains(mouseEvent.getX(), mouseEvent.getY())) continue;
            return (MouseInputListener)((Object)boundary);
        }
        return null;
    }

    private void handleEntranceAndExit(MouseEvent mouseEvent) {
        MouseInputListener mouseInputListener = this.getHandler(mouseEvent);
        if (mouseInputListener == null) {
            if (this.activeUnit != null) {
                this.activeUnit.mouseExited(mouseEvent);
                this.activeUnit = null;
            }
        } else if (mouseInputListener != null && this.activeUnit != mouseInputListener) {
            if (this.activeUnit == null) {
                this.activeUnit = mouseInputListener;
                this.activeUnit.mouseEntered(mouseEvent);
            } else if (this.activeUnit != mouseInputListener) {
                this.activeUnit.mouseExited(mouseEvent);
                this.activeUnit = mouseInputListener;
                this.activeUnit.mouseEntered(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.handleEntranceAndExit(mouseEvent);
        if (this.activeUnit != null) {
            this.activeUnit.mouseMoved(mouseEvent);
        }
    }

    public void startDragging(MouseInputListener mouseInputListener, MouseEvent mouseEvent) {
        if (this.activeUnit != null) {
            this.activeUnit.mouseReleased(mouseEvent);
        }
        this.activeUnit = mouseInputListener;
        this.activeUnit.mouseDragged(mouseEvent);
    }
}

