/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.oldphetgraphics.graphics;

import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.InteractiveGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.bounds.Boundary;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols.CompositeMouseInputListener;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols.HandCursorControl;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols.Translatable;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols.TranslationControl;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class DefaultInteractiveGraphic
implements InteractiveGraphic {
    Graphic graphic;
    CompositeMouseInputListener mouseControl;
    Boundary boundary;
    private HandCursorControl handControl;

    public DefaultInteractiveGraphic(Graphic graphic, Boundary boundary) {
        this.graphic = graphic;
        this.boundary = boundary;
        this.mouseControl = new CompositeMouseInputListener();
    }

    public void paint(Graphics2D graphics2D) {
        this.graphic.paint(graphics2D);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseControl.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseControl.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseControl.mouseReleased(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseControl.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseControl.mouseExited(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseControl.mouseDragged(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseControl.mouseMoved(mouseEvent);
    }

    public boolean contains(int n, int n2) {
        return this.boundary.contains(n, n2);
    }

    public void addCursorHandBehavior() {
        if (this.handControl == null) {
            this.handControl = new HandCursorControl();
            this.mouseControl.addMouseInputListener(this.handControl);
        }
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseControl.addMouseInputListener(mouseInputListener);
    }

    public void addTranslationBehavior(Translatable translatable) {
        this.mouseControl.addMouseInputListener(new TranslationControl(translatable));
    }
}

