/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.oldphetgraphics.graphics;

import edu.colorado.phet.common.phetcommon.util.MultiMap;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.InteractiveGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.bounds.Boundary;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols.MouseManager;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Iterator;

public class CompositeInteractiveGraphic
implements InteractiveGraphic {
    private MultiMap graphicMap;
    private HashMap graphicTxMap = new HashMap();
    private MouseManager mouseManager;

    public CompositeInteractiveGraphic() {
        this.graphicMap = new MultiMap();
        this.mouseManager = new MouseManager(this.graphicMap);
    }

    public void paint(Graphics2D graphics2D) {
        Iterator iterator = this.graphicMap.iterator();
        while (iterator.hasNext()) {
            Graphic graphic = (Graphic)iterator.next();
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = (AffineTransform)this.graphicTxMap.get(graphic);
            if (affineTransform2 != null) {
                graphics2D.transform(affineTransform2);
            }
            graphic.paint(graphics2D);
            graphics2D.setTransform(affineTransform);
        }
    }

    public boolean contains(int n, int n2) {
        Iterator iterator = this.graphicMap.iterator();
        while (iterator.hasNext()) {
            Boundary boundary;
            Object e = iterator.next();
            if (!(e instanceof Boundary) || !(boundary = (Boundary)e).contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseManager.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseManager.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseManager.mouseReleased(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseManager.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseManager.mouseExited(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseManager.mouseDragged(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseManager.mouseMoved(mouseEvent);
    }

    public void addGraphic(Graphic graphic) {
        this.addGraphic(graphic, 0.0);
    }

    public void addGraphic(Graphic graphic, double d) {
        this.graphicMap.put(new Double(d), graphic);
    }

    public MouseManager getMouseManager() {
        return this.mouseManager;
    }

    public void removeGraphic(Graphic graphic) {
        this.graphicMap.removeValue(graphic);
    }
}

