/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energyprobe;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.semiconductor.common.TransformGraphic;
import edu.colorado.phet.semiconductor.macro.energyprobe.Cable;
import edu.colorado.phet.semiconductor.macro.energyprobe.LeadGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.ShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class CableGraphic
extends TransformGraphic
implements SimpleObserver {
    Cable cable;
    LeadGraphic leadGraphic;
    ShapeGraphic shapeGraphic;

    public CableGraphic(ModelViewTransform2D modelViewTransform2D, Cable cable, LeadGraphic leadGraphic) {
        super(modelViewTransform2D);
        this.cable = cable;
        this.leadGraphic = leadGraphic;
        this.shapeGraphic = new ShapeGraphic(new Rectangle(), Color.black, new BasicStroke(4.0f));
        cable.getLead().addObserver(this);
        this.update();
    }

    public void update() {
        Point point = this.leadGraphic.getTail();
        Vector2D vector2D = this.cable.getAttachmentPoint();
        Point2D.Double double_ = vector2D.toPoint2D();
        Point point2 = this.getTransform().modelToView(double_);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(point2.x, point2.y);
        Point point3 = new Point(point2.x + 10, point2.y + 80);
        Point point4 = new Point(point.x, point.y + 200);
        generalPath.curveTo(point3.x, point3.y, point4.x, point4.y, point.x, point.y);
        this.shapeGraphic.setShape(generalPath);
    }

    public void paint(Graphics2D graphics2D) {
        this.shapeGraphic.paint(graphics2D);
    }
}

