/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.states;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticleState;
import edu.colorado.phet.semiconductor.macro.energy.states.Speed;

public class MoveToPosition
implements BandParticleState {
    private ImmutableVector2D target;
    Speed speed;

    public MoveToPosition(ImmutableVector2D immutableVector2D, Speed speed) {
        this.target = immutableVector2D;
        this.speed = speed;
    }

    public MoveToPosition(ImmutableVector2D immutableVector2D, final double d) {
        this(immutableVector2D, new Speed(){

            public double getSpeed() {
                return d;
            }
        });
    }

    public boolean stepInTime(BandParticle bandParticle, double d) {
        bandParticle.setEnergyCell(null);
        double d2 = this.speed.getSpeed() * d;
        ImmutableVector2D immutableVector2D = this.target;
        Vector2D vector2D = bandParticle.getPosition();
        ImmutableVector2D immutableVector2D2 = immutableVector2D.getSubtractedInstance(vector2D);
        double d3 = immutableVector2D2.getMagnitude();
        if (d3 <= d2) {
            bandParticle.setPosition(new Vector2D(immutableVector2D.getX(), immutableVector2D.getY()));
            return true;
        }
        ImmutableVector2D immutableVector2D3 = immutableVector2D2.getInstanceOfMagnitude(d2);
        ImmutableVector2D immutableVector2D4 = vector2D.getAddedInstance(immutableVector2D3);
        bandParticle.setPosition(new Vector2D(immutableVector2D4.getX(), immutableVector2D4.getY()));
        return false;
    }
}

