/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.states;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticleState;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.states.Speed;

public class MoveToCell
implements BandParticleState {
    private EnergyCell target;
    Speed speed;

    public MoveToCell(BandParticle bandParticle, EnergyCell energyCell, Speed speed) {
        this.target = energyCell;
        this.speed = speed;
        bandParticle.setEnergyCell(energyCell);
        bandParticle.setExcited(true);
    }

    public MoveToCell(BandParticle bandParticle, EnergyCell energyCell, final double d) {
        this(bandParticle, energyCell, new Speed(){

            public double getSpeed() {
                return d;
            }
        });
    }

    public boolean stepInTime(BandParticle bandParticle, double d) {
        bandParticle.setEnergyCell(this.target);
        double d2 = this.speed.getSpeed() * d;
        Vector2D vector2D = this.target.getPosition();
        Vector2D vector2D2 = bandParticle.getPosition();
        ImmutableVector2D immutableVector2D = vector2D.getSubtractedInstance(vector2D2);
        double d3 = immutableVector2D.getMagnitude();
        if (d3 <= d2) {
            bandParticle.setPosition(vector2D);
            return true;
        }
        ImmutableVector2D immutableVector2D2 = immutableVector2D.getInstanceOfMagnitude(d2);
        ImmutableVector2D immutableVector2D3 = vector2D2.getAddedInstance(immutableVector2D2);
        bandParticle.setPosition(new Vector2D(immutableVector2D3.getX(), immutableVector2D3.getY()));
        return false;
    }
}

