/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.statemodels;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.EntryPoint;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.states.MoveToCell;

public class Entrance
implements ModelElement {
    private EnergyCell cell;
    private EnergySection energySection;

    public Entrance(EnergySection energySection, EnergyCell energyCell) {
        this.cell = energyCell;
        this.energySection = energySection;
    }

    public EnergyCell getCell() {
        return this.cell;
    }

    public void stepInTime(double d) {
        if (this.cell.getIndex() == 0) {
            EntryPoint entryPoint = new EntryPoint(this.cell, new Vector2D(-1.0, 0.0));
            this.enter(this.energySection, entryPoint);
        } else {
            EntryPoint entryPoint = new EntryPoint(this.cell, new Vector2D(1.0, 0.0));
            this.enter(this.energySection, entryPoint);
        }
    }

    public void enter(EnergySection energySection, EntryPoint entryPoint) {
        BandParticle bandParticle = energySection.getBandParticle(entryPoint.getCell());
        if (bandParticle == null) {
            bandParticle = new BandParticle(entryPoint.getSource());
            bandParticle.setExcited(true);
            bandParticle.setState(new MoveToCell(bandParticle, entryPoint.getCell(), energySection.getSpeed()));
            energySection.addParticle(bandParticle);
        }
    }
}

