/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.statemodels;

import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.ModelCriteria;
import java.util.ArrayList;

public class DefaultCriteria
implements ModelCriteria {
    ArrayList dopantTypes;
    double minVolts;
    double maxVolts;

    public DefaultCriteria(DopantType dopantType, double d, double d2) {
        this(DefaultCriteria.toArray(dopantType), d, d2);
    }

    public static ArrayList toArray(DopantType dopantType) {
        ArrayList<DopantType> arrayList = new ArrayList<DopantType>();
        arrayList.add(dopantType);
        return arrayList;
    }

    public static ArrayList toArray(DopantType dopantType, DopantType dopantType2) {
        ArrayList<DopantType> arrayList = new ArrayList<DopantType>();
        arrayList.add(dopantType);
        arrayList.add(dopantType2);
        return arrayList;
    }

    public DefaultCriteria(ArrayList arrayList, double d, double d2) {
        this.dopantTypes = arrayList;
        this.minVolts = d;
        this.maxVolts = d2;
    }

    public DefaultCriteria(DopantType dopantType, DopantType dopantType2, double d, double d2) {
        this(DefaultCriteria.toArray(dopantType, dopantType2), d, d2);
    }

    public DefaultCriteria(DopantType dopantType, DopantType dopantType2, DopantType dopantType3, double d, double d2) {
        this(DefaultCriteria.toArray(dopantType, dopantType2, dopantType3), d, d2);
    }

    private static ArrayList toArray(DopantType dopantType, DopantType dopantType2, DopantType dopantType3) {
        ArrayList<DopantType> arrayList = new ArrayList<DopantType>();
        arrayList.add(dopantType);
        arrayList.add(dopantType2);
        arrayList.add(dopantType3);
        return arrayList;
    }

    public int numDopantTypes() {
        return this.dopantTypes.size();
    }

    public boolean isApplicable(EnergySection energySection) {
        int n = energySection.numBandSets();
        if (n != this.numDopantTypes()) {
            return false;
        }
        for (int i = 0; i < this.dopantTypes.size(); ++i) {
            DopantType dopantType = (DopantType)this.dopantTypes.get(i);
            if (dopantType == energySection.bandSetAt(i).getDopantType()) continue;
            return false;
        }
        double d = energySection.getVoltage();
        return !(d < this.minVolts) && !(d > this.maxVolts);
    }
}

