/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.bands.SemiconductorBandSet;

public class EnergyCell {
    double x;
    double energy;
    EnergyLevel level;
    int column;

    public EnergyCell(EnergyLevel energyLevel, double d, double d2, int n) {
        this.level = energyLevel;
        this.x = d;
        this.energy = d2;
        this.column = n;
    }

    public String toString() {
        return "x=" + this.x + ", energy=" + this.energy + ", level=" + this.level;
    }

    public double getX() {
        return this.x;
    }

    public double getEnergy() {
        return this.energy;
    }

    public Vector2D getPosition() {
        return new Vector2D(this.x, this.energy);
    }

    public EnergyLevel getEnergyLevel() {
        return this.level;
    }

    public int getIndex() {
        return this.getEnergyLevel().indexOf(this);
    }

    public SemiconductorBandSet getBandSet() {
        return this.getEnergyLevel().getBand().getBandSet();
    }

    public int getEnergyLevelAbsoluteIndex() {
        return this.getEnergyLevel().getAbsoluteHeight();
    }

    public int getColumn() {
        return this.column;
    }
}

