/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.semiconductor.SemiconductorResources;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandSet;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandSetGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.util.RectangleUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;

public class ChargeCountGraphic
implements Graphic {
    private EnergySection es;
    private BandSet bandSet;
    private ModelViewTransform2D transform;
    private Font font = new PhetFont(20);
    Color color = Color.black;
    BandSetGraphic bsg;
    boolean visible = false;

    public ChargeCountGraphic(EnergySection energySection, BandSetGraphic bandSetGraphic, ModelViewTransform2D modelViewTransform2D) {
        this.es = energySection;
        this.bsg = bandSetGraphic;
        this.bandSet = bandSetGraphic.bandSet;
        this.transform = modelViewTransform2D;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.visible) {
            Vector2D vector2D = RectangleUtils.getCenter(this.bsg.getViewport());
            Point point = this.transform.modelToView(vector2D);
            graphics2D.setFont(this.font);
            graphics2D.setColor(this.color);
            String string = SemiconductorResources.getString("ChargeCountGraphic.NetChargeLabel") + "=" + this.es.getExcessCharge(this.bandSet);
            int n = (int)this.font.getStringBounds(string, graphics2D.getFontRenderContext()).getWidth();
            graphics2D.drawString(string, point.x - n / 2, point.y);
        }
    }
}

