/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.semiconductor.SemiconductorResources;
import edu.colorado.phet.semiconductor.common.SimpleBufferedImageGraphic;
import edu.colorado.phet.semiconductor.common.TransformGraphic;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class BandParticleGraphic
extends TransformGraphic {
    BandParticle bandParticle;
    SimpleBufferedImageGraphic graphic;
    private static boolean showExclaim = true;
    private Font msgFont = new PhetFont(12);
    static Font exclaimFont = new PhetFont(2, 18);

    public BandParticleGraphic(BandParticle bandParticle, ModelViewTransform2D modelViewTransform2D, BufferedImage bufferedImage) {
        super(modelViewTransform2D);
        this.bandParticle = bandParticle;
        this.graphic = new SimpleBufferedImageGraphic(bufferedImage);
        modelViewTransform2D.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                BandParticleGraphic.this.update();
            }
        });
    }

    public void paint(Graphics2D graphics2D) {
        Vector2D vector2D = this.bandParticle.getPosition();
        Point point = this.getTransform().modelToView(vector2D);
        this.graphic.setPosition(point);
        this.graphic.paint(graphics2D);
        if (showExclaim && this.bandParticle.isExcited()) {
            graphics2D.setColor(Color.red);
            graphics2D.setFont(exclaimFont);
            graphics2D.drawString(SemiconductorResources.getString("BandParticleGraphic.ExclaimText"), point.x - 14, point.y);
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.msgFont);
    }

    public void update() {
    }

    public BandParticle getBandParticle() {
        return this.bandParticle;
    }
}

