/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.semiconductor.SemiconductorResources;
import edu.colorado.phet.semiconductor.common.EnergySpaceRegion;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class BandGraphic
implements Graphic {
    private EnergySection diodeSection;
    Band band;
    private ModelViewTransform2D transform;
    Stroke stroke = new BasicStroke(2.0f);

    public BandGraphic(EnergySection energySection, Band band, ModelViewTransform2D modelViewTransform2D) {
        this.diodeSection = energySection;
        this.band = band;
        this.transform = modelViewTransform2D;
        modelViewTransform2D.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                BandGraphic.this.update();
            }
        });
    }

    private void update() {
    }

    public void paint(Graphics2D graphics2D) {
        AffineTransform affineTransform = this.transform.getAffineTransform();
        EnergySpaceRegion energySpaceRegion = this.band.getRegion();
        Rectangle2D.Double double_ = new Rectangle2D.Double(energySpaceRegion.getMinX(), energySpaceRegion.getMinEnergy(), energySpaceRegion.getSpatialWidth(), energySpaceRegion.getEnergyRange());
        graphics2D.setColor(Color.yellow);
        graphics2D.fill(affineTransform.createTransformedShape(double_));
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(Color.black);
        for (int i = 0; i < this.band.numEnergyLevels(); ++i) {
            EnergyLevel energyLevel = this.band.energyLevelAt(i);
            Line2D.Double double_2 = new Line2D.Double(energyLevel.getRegion().getMinX(), energyLevel.getRegion().getMinEnergy(), energyLevel.getRegion().getMinX() + energyLevel.getRegion().getSpatialWidth(), energyLevel.getRegion().getMinEnergy());
            Shape shape = affineTransform.createTransformedShape(double_2);
            graphics2D.draw(shape);
            boolean bl = false;
            if (!bl) continue;
            graphics2D.setColor(Color.black);
            graphics2D.setFont(new PhetFont(12));
            for (int j = 0; j < energyLevel.numCells(); ++j) {
                EnergyCell energyCell = energyLevel.cellAt(j);
                Point point = this.transform.modelToView(energyCell.getPosition());
                String string = SemiconductorResources.getString("BandGraphic.NullText");
                BandParticle bandParticle = this.diodeSection.getBandParticle(energyCell);
                if (bandParticle != null) {
                    string = bandParticle.toString();
                }
                graphics2D.drawString(string, point.x + 20, point.y - 10);
            }
        }
    }
}

