/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.semiconductor.common.EnergySpaceRegion;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.bands.SemiconductorBandSet;
import java.util.ArrayList;

public class Band {
    SemiconductorBandSet bandSet;
    ArrayList levels = new ArrayList();
    private EnergySpaceRegion region;

    public Band(EnergySpaceRegion energySpaceRegion, int n, SemiconductorBandSet semiconductorBandSet, int n2) {
        this.region = energySpaceRegion;
        this.bandSet = semiconductorBandSet;
        double d = energySpaceRegion.getEnergyRange() / (double)n;
        for (int i = 0; i < n; ++i) {
            double d2 = (double)i * d + energySpaceRegion.getMinEnergy();
            EnergySpaceRegion energySpaceRegion2 = new EnergySpaceRegion(energySpaceRegion.getMinX(), d2, energySpaceRegion.getSpatialWidth(), d);
            EnergyLevel energyLevel = new EnergyLevel(this, energySpaceRegion2, n2);
            this.addLevel(energyLevel);
        }
        if (semiconductorBandSet == null) {
            throw new RuntimeException("Null bandset.");
        }
    }

    public String toString() {
        return super.toString();
    }

    public EnergySpaceRegion getRegion() {
        return this.region;
    }

    private void addLevel(EnergyLevel energyLevel) {
        this.levels.add(energyLevel);
    }

    public int numEnergyLevels() {
        return this.levels.size();
    }

    public EnergyLevel energyLevelAt(int n) {
        return (EnergyLevel)this.levels.get(n);
    }

    public int indexOf(EnergyLevel energyLevel) {
        return this.levels.indexOf(energyLevel);
    }

    public SemiconductorBandSet getBandSet() {
        return this.bandSet;
    }
}

