/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.DefaultStateDiagram;
import edu.colorado.phet.semiconductor.macro.energy.DepleteLeft;
import edu.colorado.phet.semiconductor.macro.energy.DepleteRight;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.PNPLeftClear;
import edu.colorado.phet.semiconductor.macro.energy.PNPRightClear;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.ExciteForConduction;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.ModelCriteria;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.TypeCriteria;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;

public class PNPHandler
implements ModelElement,
ModelCriteria {
    private EnergySection energySection;
    private PNPRightClear rightClear;
    private PNPLeftClear leftClear;

    public PNPHandler(EnergySection energySection) {
        int n;
        this.energySection = energySection;
        double d = 0.1;
        DefaultStateDiagram defaultStateDiagram = new DefaultStateDiagram(energySection);
        ExciteForConduction exciteForConduction = defaultStateDiagram.exciteN(2, 1);
        Move move = defaultStateDiagram.moveRight(exciteForConduction.getRightCell());
        defaultStateDiagram.moveRight(exciteForConduction.getLeftCell());
        ExciteForConduction exciteForConduction2 = defaultStateDiagram.exciteP(1, 2);
        defaultStateDiagram.move(move.getDst(), exciteForConduction2.getLeftCell(), energySection.getFallSpeed());
        defaultStateDiagram.moveRight(exciteForConduction2.getLeftCell());
        defaultStateDiagram.exitRight(exciteForConduction2.getRightCell());
        defaultStateDiagram.addFillLeft(1);
        ModelElement modelElement = new DepleteRight(1, 2, energySection);
        defaultStateDiagram.addModelElement(modelElement);
        Band band = energySection.bandSetAt(2).getConductionBand();
        for (n = 0; n < DopantType.N.getNumFilledLevels(); ++n) {
            defaultStateDiagram.move(band.energyLevelAt(n).cellAt(0), exciteForConduction2.getLeftCell(), energySection.getFallSpeed());
        }
        this.rightClear = new PNPRightClear(energySection, defaultStateDiagram);
        d = 0.1;
        defaultStateDiagram = new DefaultStateDiagram(energySection);
        exciteForConduction = defaultStateDiagram.exciteN(2, 1);
        move = defaultStateDiagram.moveLeft(exciteForConduction.getLeftCell());
        defaultStateDiagram.moveLeft(exciteForConduction.getRightCell());
        exciteForConduction2 = defaultStateDiagram.exciteP(1, 0);
        defaultStateDiagram.move(move.getDst(), exciteForConduction2.getRightCell(), energySection.getFallSpeed());
        defaultStateDiagram.moveLeft(exciteForConduction2.getRightCell());
        defaultStateDiagram.exitLeft(exciteForConduction2.getLeftCell());
        defaultStateDiagram.addFillRight(1);
        modelElement = new DepleteLeft(1, 2, energySection);
        defaultStateDiagram.addModelElement(modelElement);
        band = energySection.bandSetAt(0).getConductionBand();
        for (n = 0; n < DopantType.N.getNumFilledLevels(); ++n) {
            defaultStateDiagram.move(band.energyLevelAt(n).cellAt(1), exciteForConduction2.getRightCell(), energySection.getFallSpeed());
        }
        this.leftClear = new PNPLeftClear(energySection, defaultStateDiagram);
    }

    public boolean isApplicable(EnergySection energySection) {
        return new TypeCriteria(DopantType.P, DopantType.N, DopantType.P).isApplicable(energySection);
    }

    public void stepInTime(double d) {
        if (this.energySection.getVoltage() > 0.4) {
            this.rightClear.stepInTime(d);
        } else if (this.energySection.getVoltage() < -0.4) {
            this.leftClear.stepInTime(d);
        }
    }
}

