/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.DefaultStateDiagram;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.StateTransition;
import edu.colorado.phet.semiconductor.macro.energy.Unexcite;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.bands.SemiconductorBandSet;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.Entrance;
import edu.colorado.phet.semiconductor.macro.energy.transitions.ExitRight;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;

class NPForwardClear
extends DefaultStateDiagram {
    private ModelElement npForward;
    private int topLevel = DopantType.P.getNumFilledLevels();

    public NPForwardClear(EnergySection energySection, ModelElement modelElement) {
        super(energySection);
        this.npForward = modelElement;
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        boolean bl = this.doClear(d);
        if (bl) {
            this.npForward.stepInTime(d);
        }
    }

    public void setTopLevel(int n) {
        this.topLevel = n;
    }

    private boolean doClear(double d) {
        BandParticle bandParticle;
        Object object;
        Object object2;
        EnergyLevel energyLevel;
        int n;
        SemiconductorBandSet semiconductorBandSet = this.getEnergySection().bandSetAt(0);
        SemiconductorBandSet semiconductorBandSet2 = this.getEnergySection().bandSetAt(1);
        Band band = semiconductorBandSet2.bandAt(DopantType.P.getDopingBand());
        Band band2 = semiconductorBandSet.bandAt(DopantType.N.getDopingBand());
        boolean bl = true;
        for (n = 0; n < DopantType.N.getNumFilledLevels() - 1; ++n) {
            energyLevel = band2.energyLevelAt(n);
            if (!this.getEnergySection().isOwned(energyLevel)) {
                object2 = new Entrance(this.getEnergySection(), energyLevel.cellAt(0));
                ((Entrance)object2).stepInTime(d);
                object = new Move(((Entrance)object2).getCell(), this.getEnergySection().getRightNeighbor(((Entrance)object2).getCell()), this.getSpeed());
                bandParticle = this.getEnergySection().getBandParticle(((Entrance)object2).getCell());
                if (bandParticle != null && bandParticle.isLocatedAtCell()) {
                    ((StateTransition)object).apply(bandParticle, this.getEnergySection());
                }
                bl = false;
                break;
            }
            object2 = this.getEnergySection().getBandParticle(energyLevel.cellAt(0));
            object = this.getEnergySection().getBandParticle(energyLevel.cellAt(1));
            new Unexcite(energyLevel.cellAt(0)).apply((BandParticle)object2);
            new Unexcite(energyLevel.cellAt(1)).apply((BandParticle)object);
        }
        for (n = band.numEnergyLevels() - 1; n >= this.topLevel; --n) {
            energyLevel = band.energyLevelAt(n);
            object2 = energyLevel.cellAt(0);
            object = energyLevel.cellAt(1);
            bandParticle = this.getEnergySection().getBandParticle((EnergyCell)object2);
            BandParticle bandParticle2 = this.getEnergySection().getBandParticle((EnergyCell)object);
            if (bandParticle != null && bandParticle2 != null && n != DopantType.P.getNumFilledLevels()) {
                bl = false;
            }
            if (bandParticle2 != null) {
                ExitRight exitRight = new ExitRight();
                exitRight.apply(bandParticle2, this.getEnergySection());
                break;
            }
            if (bandParticle == null) continue;
            Move move = new Move((EnergyCell)object2, (EnergyCell)object, this.getSpeed());
            move.apply(bandParticle, this.getEnergySection());
            break;
        }
        return bl;
    }
}

