/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.StateTransition;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.transitions.ExitLeftFrom;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;

public class DepleteLeft
implements ModelElement {
    int bandSet;
    int band;
    EnergySection energySection;

    public DepleteLeft(int n, int n2, EnergySection energySection) {
        this.bandSet = n;
        this.band = n2;
        this.energySection = energySection;
    }

    public int highestClaimedLevel() {
        Band band = this.energySection.bandSetAt(this.bandSet).bandAt(this.band);
        for (int i = 0; i < band.numEnergyLevels(); ++i) {
            int n = band.numEnergyLevels() - 1 - i;
            EnergyLevel energyLevel = band.energyLevelAt(n);
            if (!this.energySection.isClaimed(energyLevel.cellAt(0)) && !this.energySection.isClaimed(energyLevel.cellAt(1))) continue;
            return n;
        }
        return -1;
    }

    public void stepInTime(double d) {
        boolean bl;
        StateTransition stateTransition;
        int n = this.highestClaimedLevel();
        if (n == -1) {
            return;
        }
        EnergyLevel energyLevel = this.energySection.bandSetAt(this.bandSet).bandAt(this.band).energyLevelAt(n);
        BandParticle bandParticle = this.energySection.getBandParticle(energyLevel.cellAt(0));
        BandParticle bandParticle2 = this.energySection.getBandParticle(energyLevel.cellAt(1));
        if (bandParticle2 != null) {
            if (bandParticle2.isExcited()) {
                stateTransition = new Move(bandParticle2.getEnergyCell(), this.energySection.getLeftNeighbor(bandParticle2.getEnergyCell()), this.energySection.getSpeed());
                bl = stateTransition.apply(bandParticle2, this.energySection);
            } else {
                stateTransition = new Move(bandParticle2.getEnergyCell(), this.energySection.getUpperNeighbor(bandParticle2.getEnergyCell()), this.energySection.getSpeed());
                bl = stateTransition.apply(bandParticle2, this.energySection);
            }
        }
        if (bandParticle != null) {
            if (bandParticle.isExcited()) {
                if (this.bandSet == 0) {
                    stateTransition = new ExitLeftFrom(bandParticle.getEnergyCell());
                    bl = stateTransition.apply(bandParticle, this.energySection);
                } else {
                    stateTransition = new Move(bandParticle.getEnergyCell(), this.energySection.getLeftNeighbor(bandParticle.getEnergyCell()), this.energySection.getSpeed());
                    bl = stateTransition.apply(bandParticle, this.energySection);
                }
            } else {
                stateTransition = new Move(bandParticle.getEnergyCell(), this.energySection.getUpperNeighbor(bandParticle.getEnergyCell()), this.energySection.getSpeed());
                bl = stateTransition.apply(bandParticle, this.energySection);
            }
        }
    }
}

