/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.doping;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.semiconductor.SemiconductorResources;
import edu.colorado.phet.semiconductor.common.BorderGraphic;
import edu.colorado.phet.semiconductor.common.ModelLocation;
import edu.colorado.phet.semiconductor.common.TextGraphic;
import edu.colorado.phet.semiconductor.macro.doping.Dopant;
import edu.colorado.phet.semiconductor.macro.doping.DopantDropListener;
import edu.colorado.phet.semiconductor.macro.doping.DopantGraphic;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.doping.ViewChangeListener;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.ApparatusPanel;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.CompositeInteractiveGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.DefaultInteractiveGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.InteractiveGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.ShapeGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols.DragToCreate;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols.InteractiveGraphicCreator;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols.Translatable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.MouseInputAdapter;

public class DopantPanel
extends CompositeInteractiveGraphic {
    Rectangle viewRect;
    private BorderGraphic border;
    private ApparatusPanel apparatusPanel;
    private ModelViewTransform2D transform;
    private DopantGraphic posDopGraphic;
    private DopantGraphic negDopGraphic;
    ShapeGraphic background;
    private boolean visible = true;
    ArrayList dopantListeners = new ArrayList();
    private Hashtable map = new Hashtable();

    public DopantPanel(ApparatusPanel apparatusPanel, final ModelViewTransform2D modelViewTransform2D, BufferedImage bufferedImage, BufferedImage bufferedImage2, final Rectangle2D.Double double_) throws IOException {
        this.apparatusPanel = apparatusPanel;
        this.transform = modelViewTransform2D;
        this.viewRect = modelViewTransform2D.modelToView(double_);
        this.background = new ShapeGraphic(this.viewRect, new Color(200, 200, 245));
        modelViewTransform2D.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D2) {
                DopantPanel.this.viewRect = modelViewTransform2D.modelToView(double_);
                DopantPanel.this.border.setRectangle(DopantPanel.this.viewRect);
                DopantPanel.this.background.setShape(DopantPanel.this.viewRect);
            }
        });
        Border border = BorderFactory.createLineBorder(Color.blue, 2);
        PhetFont phetFont = new PhetFont(1, 16);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, SemiconductorResources.getString("DopantPanel.DopantBorder"), 0, 0, phetFont, Color.black);
        this.border = new BorderGraphic(titledBorder, apparatusPanel, this.viewRect);
        ImmutableVector2D immutableVector2D = this.getCenter(double_).getAddedInstance(0.0, -double_.getHeight() / 5.5);
        ImmutableVector2D immutableVector2D2 = this.getCenter(double_).getAddedInstance(0.0, double_.getHeight() / 5.5);
        Dopant dopant = new Dopant(immutableVector2D, DopantType.N);
        Dopant dopant2 = new Dopant(immutableVector2D2, DopantType.P);
        CompositeInteractiveGraphic compositeInteractiveGraphic = new CompositeInteractiveGraphic();
        CompositeInteractiveGraphic compositeInteractiveGraphic2 = new CompositeInteractiveGraphic();
        this.posDopGraphic = new DopantGraphic(dopant2, modelViewTransform2D, bufferedImage2, 5.0);
        this.negDopGraphic = new DopantGraphic(dopant, modelViewTransform2D, bufferedImage, 5.0);
        compositeInteractiveGraphic.addGraphic(this.posDopGraphic);
        compositeInteractiveGraphic2.addGraphic(this.negDopGraphic);
        this.addText(SemiconductorResources.getString("DopantPanel.PositiveTypeText"), compositeInteractiveGraphic, immutableVector2D2, modelViewTransform2D);
        this.addText(SemiconductorResources.getString("DopantPanel.NegativeTypeText"), compositeInteractiveGraphic2, immutableVector2D, modelViewTransform2D);
        InteractiveGraphicCreator interactiveGraphicCreator = this.makeSource(dopant, bufferedImage, false, "N");
        InteractiveGraphicCreator interactiveGraphicCreator2 = this.makeSource(dopant2, bufferedImage2, true, "P");
        DragToCreate dragToCreate = new DragToCreate(interactiveGraphicCreator, this, 10000.0);
        DragToCreate dragToCreate2 = new DragToCreate(interactiveGraphicCreator2, this, 10000.0);
        DefaultInteractiveGraphic defaultInteractiveGraphic = new DefaultInteractiveGraphic(compositeInteractiveGraphic2, this.negDopGraphic);
        defaultInteractiveGraphic.addMouseInputListener(dragToCreate);
        defaultInteractiveGraphic.addCursorHandBehavior();
        this.addGraphic(defaultInteractiveGraphic, 0.0);
        DefaultInteractiveGraphic defaultInteractiveGraphic2 = new DefaultInteractiveGraphic(compositeInteractiveGraphic, this.posDopGraphic);
        defaultInteractiveGraphic2.addMouseInputListener(dragToCreate2);
        defaultInteractiveGraphic2.addCursorHandBehavior();
        this.addGraphic(defaultInteractiveGraphic2, 0.0);
    }

    private void addText(String string, CompositeInteractiveGraphic compositeInteractiveGraphic, ImmutableVector2D immutableVector2D, ModelViewTransform2D modelViewTransform2D) {
        final TextGraphic textGraphic = new TextGraphic(100.0, 100.0, new PhetFont(0, 14), Color.black, string);
        ViewChangeListener viewChangeListener = new ViewChangeListener(){

            public void viewCoordinateChanged(int n, int n2) {
                textGraphic.setPosition(n - 25, n2 - 23);
            }
        };
        compositeInteractiveGraphic.addGraphic(textGraphic);
        ModelLocation modelLocation = new ModelLocation(immutableVector2D.getX(), immutableVector2D.getY(), modelViewTransform2D);
        modelLocation.addViewChangeListener(viewChangeListener);
    }

    public void addDopantDropListener(DopantDropListener dopantDropListener) {
        this.dopantListeners.add(dopantDropListener);
    }

    InteractiveGraphicCreator makeSource(final Dopant dopant, final BufferedImage bufferedImage, final boolean bl, final String string) {
        InteractiveGraphicCreator interactiveGraphicCreator = new InteractiveGraphicCreator(){

            public InteractiveGraphic newInstance() {
                return new DopantSourceGraphic(dopant, bufferedImage, bl, string).getGraphic();
            }
        };
        return interactiveGraphicCreator;
    }

    private Vector2D getCenter(Rectangle2D.Double double_) {
        return new Vector2D(double_.x + double_.width / 2.0, double_.y + double_.height / 2.0);
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.visible) {
            return;
        }
        this.background.paint(graphics2D);
        this.border.paint(graphics2D);
        super.paint(graphics2D);
    }

    public void removeDopant(DopantGraphic dopantGraphic) {
        Graphic graphic = (Graphic)this.map.get(dopantGraphic);
        super.removeGraphic(graphic);
    }

    class DopantSourceGraphic {
        DefaultInteractiveGraphic graphic;

        public DopantSourceGraphic(Dopant dopant, BufferedImage bufferedImage, boolean bl, String string) {
            Dopant dopant2 = new Dopant(dopant.getPosition(), bl ? DopantType.P : DopantType.N);
            final DopantGraphic dopantGraphic = new DopantGraphic(dopant2, DopantPanel.this.transform, bufferedImage, 5.0);
            CompositeInteractiveGraphic compositeInteractiveGraphic = new CompositeInteractiveGraphic();
            compositeInteractiveGraphic.addGraphic(dopantGraphic);
            this.graphic = new DefaultInteractiveGraphic(compositeInteractiveGraphic, dopantGraphic);
            DopantPanel.this.map.put(dopantGraphic, this.graphic);
            Translatable translatable = new Translatable(){

                public void translate(double d, double d2) {
                    Point2D point2D = DopantPanel.this.transform.viewToModelDifferential((int)d, (int)d2);
                    point2D.setLocation(point2D.getX() + dopantGraphic.getDopant().getPosition().getX(), point2D.getY() + dopantGraphic.getDopant().getPosition().getY());
                    if (point2D.getX() < 5.7) {
                        d = 0.0;
                    }
                    dopantGraphic.translate(d, d2);
                    DopantPanel.this.apparatusPanel.repaint();
                }
            };
            this.graphic.addCursorHandBehavior();
            this.graphic.addTranslationBehavior(translatable);
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    for (int i = 0; i < DopantPanel.this.dopantListeners.size(); ++i) {
                        DopantDropListener dopantDropListener = (DopantDropListener)DopantPanel.this.dopantListeners.get(i);
                        dopantDropListener.dopantDropped(dopantGraphic);
                    }
                }
            };
            this.graphic.addMouseInputListener(mouseInputAdapter);
        }

        public InteractiveGraphic getGraphic() {
            return this.graphic;
        }
    }
}

