/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.doping;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.semiconductor.common.SimpleBufferedImageGraphic;
import edu.colorado.phet.semiconductor.common.TransformGraphic;
import edu.colorado.phet.semiconductor.macro.doping.Dopant;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.bounds.Boundary;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class DopantGraphic
extends TransformGraphic
implements Boundary {
    Dopant dopant;
    private Point viewLoc;
    private SimpleBufferedImageGraphic imageGraphic;
    private BufferedImage buffer;

    public DopantGraphic(Dopant dopant, ModelViewTransform2D modelViewTransform2D, BufferedImage bufferedImage, double d) {
        super(modelViewTransform2D);
        this.buffer = new BufferedImage(bufferedImage.getWidth() * 3, bufferedImage.getHeight() * 3, 2);
        Graphics2D graphics2D = this.buffer.createGraphics();
        graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight())));
        graphics2D.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        this.imageGraphic = new SimpleBufferedImageGraphic(this.buffer);
        this.dopant = dopant;
        this.update();
        dopant.addObserver(new SimpleObserver(){

            public void update() {
                DopantGraphic.this.update();
            }
        });
    }

    public void paint(Graphics2D graphics2D) {
        this.imageGraphic.paint(graphics2D);
    }

    public void update() {
        this.viewLoc = super.getTransform().modelToView(this.dopant.getPosition());
        this.imageGraphic.setPosition(this.viewLoc);
    }

    public boolean contains(int n, int n2) {
        Shape shape = this.getShape();
        return shape.contains(n, n2);
    }

    public Shape getShape() {
        return this.imageGraphic.getShape();
    }

    public void translate(double d, double d2) {
        Point2D point2D = this.getTransform().viewToModelDifferential((int)d, (int)d2);
        this.dopant.translate(point2D.getX(), point2D.getY());
    }

    public Dopant getDopant() {
        return this.dopant;
    }

    public DopantType getType() {
        return this.dopant.getType();
    }

    public Vector2D getCenter() {
        return new Vector2D(this.viewLoc);
    }
}

