/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.circuit.battery;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.semiconductor.SemiconductorResources;
import edu.colorado.phet.semiconductor.macro.circuit.battery.Battery;
import edu.colorado.phet.semiconductor.macro.circuit.battery.MyJSpinner;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BatterySpinner {
    JSpinner spinner;
    DecimalFormat df = new DecimalFormat("##.00#");
    private final Battery battery;

    public BatterySpinner(final Battery battery) {
        this.battery = battery;
        this.spinner = new MyJSpinner(new SpinnerNumberModel(battery.getVoltage(), -4.0, 4.0, 0.1));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(SemiconductorResources.getString("BatterySpinner.BorderTitle"));
        titledBorder.setTitleFont(new PhetFont(0, 18));
        this.spinner.setBorder(titledBorder);
        this.spinner.setPreferredSize(new Dimension(125, 100));
        this.spinner.getEditor().setFont(new PhetFont(1, 20));
        if (this.spinner.getEditor() instanceof JSpinner.DefaultEditor) {
            final JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.spinner.getEditor();
            defaultEditor.getTextField().addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    String string = defaultEditor.getTextField().getText();
                    try {
                        double d = BatterySpinner.this.parse(string);
                        if (d >= -4.0 && d <= 4.0) {
                            BatterySpinner.this.setVoltage(d);
                        } else {
                            PhetOptionPane.showMessageDialog(BatterySpinner.this.getSpinner(), "Please enter a voltage between -4.0 and 4.0 volts.");
                            BatterySpinner.this.spinner.setValue(new Double(battery.getVoltage()));
                            if (BatterySpinner.this.spinner.getEditor() instanceof JSpinner.DefaultEditor) {
                                JSpinner.DefaultEditor defaultEditor2 = (JSpinner.DefaultEditor)BatterySpinner.this.spinner.getEditor();
                                defaultEditor2.getTextField().setText(battery.getVoltage() + "");
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println(this.getClass().getName() + " - Error: Number format exception caught.");
                        System.err.println(" Attempted to convert: " + string);
                        numberFormatException.printStackTrace();
                    }
                }
            });
        }
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BatterySpinner.this.updateValue();
            }
        });
    }

    private void updateValue() {
        this.setVoltage((Double)this.spinner.getValue());
    }

    private void setVoltage(double d) {
        this.battery.setVoltage(this.parse(this.df.format(d)));
    }

    private double parse(String string) {
        double d = 0.0;
        try {
            d = this.df.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            System.err.println(this.getClass().getName() + " - Error: caught parse exception.");
            parseException.printStackTrace();
        }
        return d;
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }
}

