/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.circuit;

import edu.colorado.phet.semiconductor.macro.circuit.Circuit;
import edu.colorado.phet.semiconductor.macro.circuit.Resistor;
import edu.colorado.phet.semiconductor.macro.circuit.battery.Battery;

public class MacroCircuit
extends Circuit {
    private Resistor resistor;
    private Battery battery;

    public MacroCircuit(double d, double d2, double d3, double d4, double d5) {
        super(d, d2, d5);
        double d6 = d3 * 0.4;
        double d7 = d3 * 0.25;
        double d8 = (d3 - d6) / 2.0;
        double d9 = (d3 - d7) / 2.0;
        this.wireTo(d + d8, d2);
        this.resistor = this.resistorTo(d + d8 + d6, d2);
        this.wireTo(d + d3, d2);
        this.wireTo(d + d3, d2 + d4);
        this.wireTo(d + d3 - d9, d2 + d4);
        this.battery = this.batteryTo(d + d9, d2 + d4);
        this.wireTo(d, d2 + d4);
        this.wireTo(d, d2);
    }

    public Resistor getResistor() {
        return this.resistor;
    }

    public Battery getBattery() {
        return this.battery;
    }
}

