/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.circuit;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.semiconductor.SemiconductorApplication;
import edu.colorado.phet.semiconductor.SemiconductorResources;
import edu.colorado.phet.semiconductor.macro.circuit.ConductionListener;
import edu.colorado.phet.semiconductor.macro.circuit.MacroCircuit;
import edu.colorado.phet.semiconductor.macro.circuit.MacroCircuitGraphic;
import edu.colorado.phet.semiconductor.macro.circuit.battery.BatterySpinner;
import edu.colorado.phet.semiconductor.macro.circuit.particles.WireParticle;
import edu.colorado.phet.semiconductor.macro.circuit.particles.WireParticleGraphic;
import edu.colorado.phet.semiconductor.macro.doping.DopantChangeListener;
import edu.colorado.phet.semiconductor.macro.doping.DopantDropListener;
import edu.colorado.phet.semiconductor.macro.doping.DopantGraphic;
import edu.colorado.phet.semiconductor.macro.doping.DopantSlot;
import edu.colorado.phet.semiconductor.macro.energy.states.Speed;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.util.RectangleUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JSpinner;

public class CircuitSection
implements ModelElement,
ConductionListener,
DopantDropListener,
Speed,
Graphic {
    MacroCircuit circuit;
    MacroCircuitGraphic circuitGraphic;
    private SemiconductorApplication application;
    private ModelViewTransform2D transform;
    ArrayList particles = new ArrayList();
    ArrayList particleGraphics = new ArrayList();
    private BatterySpinner batterySpinner;
    ArrayList dopantSlots = new ArrayList();
    private JButton jb;
    private ArrayList dopantChangeListeners = new ArrayList();
    private boolean conductionAllowed;
    private Shape dopantRect;
    private double macroSpeed = 0.0;

    public CircuitSection(SemiconductorApplication semiconductorApplication, ModelViewTransform2D modelViewTransform2D, double d, double d2, double d3, double d4, int n) throws IOException {
        this.application = semiconductorApplication;
        this.transform = modelViewTransform2D;
        double d5 = 1.0;
        this.circuit = new MacroCircuit(d, d2, d3, d4, d5);
        this.circuitGraphic = new MacroCircuitGraphic(this.circuit, modelViewTransform2D);
        double d6 = 0.5;
        double d7 = this.circuit.getLength();
        int n2 = (int)(d7 / d6 + 1.0);
        double d8 = 0.0;
        for (int i = 0; i < n2; ++i) {
            WireParticle wireParticle = new WireParticle(d8, this.circuit);
            this.particles.add(wireParticle);
            WireParticleGraphic wireParticleGraphic = new WireParticleGraphic(wireParticle, modelViewTransform2D, MacroCircuitGraphic.getParticleImage());
            this.particleGraphics.add(wireParticleGraphic);
            d8 += d6;
        }
        this.batterySpinner = new BatterySpinner(this.circuit.getBattery());
        modelViewTransform2D.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                CircuitSection.this.relayoutBatterySpinner();
                CircuitSection.this.relayoutClearButton();
            }
        });
        this.jb = new JButton(SemiconductorResources.getString("CircuitSection.ClearButton")){

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(new BasicStroke(1.0f));
                super.paintComponent(graphics);
            }
        };
        this.jb.setEnabled(false);
        this.jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CircuitSection.this.clearDopants();
            }
        });
        this.addDopantSlots(n);
    }

    private void clearDopantSlots() {
        this.dopantSlots.clear();
    }

    private void addDopantSlots(int n) {
        Color color = new Color(220, 155, 225);
        for (int i = 0; i < n; ++i) {
            Shape shape = this.getDopantSlotShape(i, n);
            DopantSlot dopantSlot = null;
            try {
                dopantSlot = new DopantSlot(null, shape, this.transform, color);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.dopantSlots.add(dopantSlot);
        }
    }

    private void clearDopants() {
        for (int i = 0; i < this.numDopantSlots(); ++i) {
            this.dopantSlotAt(i).setDopantType(null);
        }
        this.updateDopantChangeListeners();
        this.jb.setEnabled(false);
    }

    public Shape getDopantSlotShape(int n, int n2) {
        double d = this.circuit.getResistor().getLength();
        double d2 = ++n * 2 - 1;
        double d3 = n2 * 2;
        double d4 = d2 / d3;
        double d5 = d / (double)n2;
        ImmutableVector2D immutableVector2D = this.circuit.getResistor().getLocation(d4 * d);
        double d6 = this.circuit.getResistor().getHeight();
        RoundRectangle2D.Double double_ = this.createCenteredRect(immutableVector2D, d5, d6, 0.3, 0.3);
        return double_;
    }

    private RoundRectangle2D.Double createCenteredRect(ImmutableVector2D immutableVector2D, double d, double d2, double d3, double d4) {
        return new RoundRectangle2D.Double(immutableVector2D.getX() - d / 2.0, immutableVector2D.getY() - d2 / 2.0, d, d2, d3, d4);
    }

    public int numDopantSlots() {
        return this.dopantSlots.size();
    }

    public DopantSlot dopantSlotAt(int n) {
        return (DopantSlot)this.dopantSlots.get(n);
    }

    private void relayoutClearButton() {
        Point point = this.transform.modelToView(this.circuit.getResistor().getStartPosition());
        this.jb.setBounds(point.x, point.y - 75, this.jb.getPreferredSize().width, this.jb.getPreferredSize().height);
    }

    public void stepInTime(double d) {
        if (this.conductionAllowed) {
            for (int i = 0; i < this.particles.size(); ++i) {
                WireParticle wireParticle = (WireParticle)this.particles.get(i);
                wireParticle.setSpeed(this.getMacroSpeed());
                wireParticle.stepInTime(d);
            }
        }
    }

    private double getMacroSpeed() {
        return this.macroSpeed;
    }

    public double getSpeed() {
        double d;
        double d2 = this.getCircuit().getBattery().getVoltage();
        double d3 = d2 * (d = 0.06666666666666667);
        if (d3 >= 0.0 && d3 < 0.021) {
            d3 = 0.021;
        }
        if (d3 <= 0.0 && d3 > -0.021) {
            d3 = 0.021;
        }
        if (d3 < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    private void relayoutBatterySpinner() {
        Point point = this.transform.modelToView(this.circuit.getBattery().getEndPosition());
        JSpinner jSpinner = this.batterySpinner.getSpinner();
        jSpinner.setBounds(point.x, point.y + jSpinner.getPreferredSize().height - 75, jSpinner.getPreferredSize().width, jSpinner.getPreferredSize().height);
        jSpinner.invalidate();
        jSpinner.validate();
        jSpinner.doLayout();
        jSpinner.revalidate();
        jSpinner.repaint();
    }

    public void paint(Graphics2D graphics2D) {
        Object object;
        int n;
        this.circuitGraphic.paint(graphics2D);
        for (n = 0; n < this.dopantSlots.size(); ++n) {
            object = this.dopantSlotAt(n);
            ((DopantSlot)object).paint(graphics2D);
        }
        for (n = 0; n < this.particleGraphics.size(); ++n) {
            object = (Graphic)this.particleGraphics.get(n);
            object.paint(graphics2D);
        }
    }

    public MacroCircuit getCircuit() {
        return this.circuit;
    }

    public BatterySpinner getBatterySpinner() {
        return this.batterySpinner;
    }

    public void addDopantChangeListener(DopantChangeListener dopantChangeListener) {
        this.dopantChangeListeners.add(dopantChangeListener);
    }

    public void dopantDropped(DopantGraphic dopantGraphic) {
        DopantSlot dopantSlot = null;
        double d = 0.0;
        this.dopantRect = dopantGraphic.getShape();
        for (int i = 0; i < this.numDopantSlots(); ++i) {
            DopantSlot dopantSlot2 = this.dopantSlotAt(i);
            Shape shape = dopantSlot2.getViewShape();
            double d2 = dopantGraphic.getCenter().getSubtractedInstance(this.getCenter(shape)).getMagnitude();
            boolean bl = this.dopantSlotAt(i).getViewShape().intersects(this.dopantRect.getBounds2D());
            if (!bl || dopantSlot != null && !(d2 < d)) continue;
            dopantSlot = dopantSlot2;
            d = d2;
        }
        if (dopantSlot != null) {
            dopantSlot.setDopantType(dopantGraphic.getType());
            this.application.removeDopantGraphic(dopantGraphic);
            this.jb.setEnabled(true);
            this.updateDopantChangeListeners();
        }
    }

    Vector2D getCenter(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        return RectangleUtils.getCenter(rectangle2D);
    }

    private void updateDopantChangeListeners() {
        for (int i = 0; i < this.dopantChangeListeners.size(); ++i) {
            DopantChangeListener dopantChangeListener = (DopantChangeListener)this.dopantChangeListeners.get(i);
            dopantChangeListener.dopingChanged(this);
        }
    }

    public JButton getClearDopantButton() {
        return this.jb;
    }

    public void setConductionAllowed(boolean bl) {
        this.conductionAllowed = bl;
    }

    public void setSingleSection() {
        this.setSectionCount(1);
    }

    public void setDoubleSection() {
        this.setSectionCount(2);
    }

    private void setSectionCount(int n) {
        this.clearDopantSlots();
        this.addDopantSlots(n);
    }

    public void setMacroSpeed(double d) {
        this.macroSpeed = d;
    }
}

