/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.semiconductor.macro.Magnet;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticleState;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.states.MoveToPosition;
import java.util.Random;

public class GoToMagnet
implements BandParticleState {
    Magnet magnet;
    static final Random random = new Random(0L);
    private double dx;
    private double dy;
    EnergyCell from;

    public GoToMagnet(Magnet magnet, EnergyCell energyCell) {
        this.magnet = magnet;
        this.from = energyCell;
        double d = magnet.getBounds().getWidth() * 0.3;
        this.dx = random.nextDouble() * d - d / 2.0;
        this.dy = random.nextDouble() * d - d / 2.0;
    }

    public boolean stepInTime(BandParticle bandParticle, double d) {
        Vector2D vector2D = this.magnet.getPlusSide();
        ImmutableVector2D immutableVector2D = vector2D.getAddedInstance(this.dx, this.dy);
        MoveToPosition moveToPosition = new MoveToPosition(immutableVector2D, 0.2);
        moveToPosition.stepInTime(bandParticle, d);
        return false;
    }

    public EnergyCell getFrom() {
        return this.from;
    }
}

