/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.semiconductor.common.SimpleBufferedImageGraphic;
import edu.colorado.phet.semiconductor.common.TransformGraphic;
import edu.colorado.phet.semiconductor.macro.EntryPoint;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;

public class BucketSection
extends TransformGraphic {
    EnergySection model;
    private BufferedImage image;
    final ArrayList spackle = new ArrayList();
    static final Random random = new Random();
    int N = 12;
    private double diameter;

    public BucketSection(ModelViewTransform2D modelViewTransform2D, EnergySection energySection, BufferedImage bufferedImage) {
        super(modelViewTransform2D);
        this.model = energySection;
        this.image = bufferedImage;
        for (int i = 0; i < this.N; ++i) {
            this.diameter = (double)bufferedImage.getWidth() * 2.0;
            double d = random.nextDouble() * this.diameter - this.diameter / 2.0;
            double d2 = random.nextDouble() * this.diameter - this.diameter / 2.0;
            Point point = new Point((int)d, (int)d2);
            this.spackle.add(point);
        }
    }

    public void paint(Graphics2D graphics2D) {
        double d = Math.abs(this.model.getVoltage());
        double d2 = d / 4.0;
        int n = (int)(d2 * (double)this.N);
        EntryPoint[] entryPointArray = this.model.getSources();
        for (int i = 0; i < entryPointArray.length; ++i) {
            Vector2D vector2D = entryPointArray[i].getSource();
            double d3 = entryPointArray[i].getSource().getX();
            double d4 = entryPointArray[i].getCell().getX();
            int n2 = (int)((d3 - d4) / Math.abs(d3 - d4));
            Point point = super.getTransform().modelToView(vector2D);
            Point point2 = new Point((int)((double)point.x + (double)n2 * this.diameter / 2.0), point.y);
            this.spackleAt(graphics2D, point2, n);
        }
    }

    private void spackleAt(Graphics2D graphics2D, Point point, int n) {
        SimpleBufferedImageGraphic simpleBufferedImageGraphic = new SimpleBufferedImageGraphic(this.image);
        for (int i = 0; i < this.spackle.size() && i <= n; ++i) {
            Point point2 = (Point)this.spackle.get(i);
            simpleBufferedImageGraphic.setPosition(point.x + point2.x, point.y + point2.y);
            simpleBufferedImageGraphic.paint(graphics2D);
        }
    }

    public void update() {
    }
}

