/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.common;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class StretchedBufferedImage
implements Graphic {
    private BufferedImage battIm;
    private Rectangle rectangle;
    private boolean flipX;

    public StretchedBufferedImage(BufferedImage bufferedImage, Rectangle rectangle) {
        this.battIm = bufferedImage;
        this.rectangle = new Rectangle(rectangle);
        if (rectangle.width == 0 || rectangle.height == 0) {
            throw new RuntimeException("Zero width or height rect.");
        }
    }

    public void paint(Graphics2D graphics2D) {
        int n = this.battIm.getWidth();
        int n2 = this.battIm.getHeight();
        n = Math.max(1, n);
        n2 = Math.max(1, n2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
        ModelViewTransform2D modelViewTransform2D = new ModelViewTransform2D(double_, this.rectangle);
        AffineTransform affineTransform = modelViewTransform2D.getAffineTransform();
        if (this.flipX) {
            affineTransform.concatenate(AffineTransform.getScaleInstance(-1.0, 1.0));
            affineTransform.concatenate(AffineTransform.getTranslateInstance(-n, 0.0));
        }
        graphics2D.drawRenderedImage(this.battIm, affineTransform);
    }

    public void setFlipX(boolean bl) {
        this.flipX = bl;
    }

    public void setOutputRect(Rectangle rectangle) {
        this.rectangle = rectangle;
    }
}

