/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.common;

import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.bounds.Boundary;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class SimpleBufferedImageGraphic
implements Graphic,
Boundary {
    BufferedImage image;
    AffineTransform transform;

    public SimpleBufferedImageGraphic(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        if (bufferedImage == null) {
            throw new RuntimeException("Null image.");
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.image != null && this.transform != null) {
            graphics2D.drawRenderedImage(this.image, this.transform);
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public void setPosition(Point point) {
        this.setTransform(this.getCenterTransform(point));
    }

    private AffineTransform getCenterTransform(Point point) {
        double d = this.image.getWidth();
        double d2 = this.image.getHeight();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)point.x - d / 2.0, (double)point.y - d2 / 2.0);
        return affineTransform;
    }

    public void setPosition(int n, int n2) {
        this.setPosition(new Point(n, n2));
    }

    public boolean contains(int n, int n2) {
        return this.getShape().contains(n, n2);
    }

    public Shape getShape() {
        Rectangle rectangle = new Rectangle(this.image.getWidth(), this.image.getHeight());
        Shape shape = this.transform.createTransformedShape(rectangle);
        return shape;
    }
}

