/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.view;

import edu.colorado.phet.selfdrivenparticlemodel.model.Particle;
import edu.colorado.phet.selfdrivenparticlemodel.model.ParticleModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Ellipse2D;

public class ParticleInfluenceGraphic
extends PNode {
    private Particle p;
    private PPath child;
    private ParticleModel particleModel;
    public static int count = 0;

    public ParticleInfluenceGraphic(ParticleModel particleModel, Particle particle) {
        ++count;
        this.particleModel = particleModel;
        this.p = particle;
        double d = this.getRadius();
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d, -d, d * 2.0, d * 2.0);
        this.child = new PPath(double_);
        this.child.setStrokePaint(null);
        this.child.setPaint(Color.yellow);
        this.addChild(this.child);
        particle.addListener(new Particle.Listener(){

            public void locationChanged() {
                ParticleInfluenceGraphic.this.update();
            }
        });
        particleModel.addListener(new ParticleModel.Adapter(){

            public void radiusChanged() {
                ParticleInfluenceGraphic.this.update();
            }
        });
        this.update();
    }

    private double getRadius() {
        double d = this.particleModel.getRadius();
        return d;
    }

    private void update() {
        double d = this.getRadius();
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d, -d, d * 2.0, d * 2.0);
        this.child.setPathTo(double_);
        this.setOffset(this.p.getX(), this.p.getY());
    }

    public Particle getParticle() {
        return this.p;
    }
}

