/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2;

import edu.colorado.phet.selfdrivenparticlemodel.model.ParticleModel;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.BasicTutorialCanvas;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.PButton;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.TutorialChartFrame;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.OrderParameter90;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.OrderParameterVsTimeChart;
import edu.umd.cs.piccolo.PNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;

public class PlotOrderParameterVsTime
extends OrderParameter90 {
    private PButton plotButton;
    private OrderParameterVsTimeChart orderParameterVsTimeChart;
    private TutorialChartFrame tutorialChartFrame;
    private ParticleModel.Adapter listener;

    public PlotOrderParameterVsTime(BasicTutorialCanvas basicTutorialCanvas) {
        super(basicTutorialCanvas);
        this.setText("Let's plot this data.  Create a graph, then manipulate values while the chart is running to observe the effects on the order parameter.");
        this.setFinishText("\n Notice how it takes the order parameter some time to adjust to changes in model parameters.");
        this.plotButton = new PButton(basicTutorialCanvas, "Plot Order Parameter vs Time");
        this.plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotOrderParameterVsTime.this.showPlot();
                PlotOrderParameterVsTime.this.startDataTaking();
                PlotOrderParameterVsTime.this.advance();
            }
        });
        this.orderParameterVsTimeChart = new OrderParameterVsTimeChart(100);
        this.tutorialChartFrame = new TutorialChartFrame("Plot", this.orderParameterVsTimeChart.getChart(), this.getBasePage().getTutorialApplication().getTutorialFrame());
        this.listener = new ParticleModel.Adapter(){

            public void steppedInTime() {
                if (PlotOrderParameterVsTime.this.getParticleModel().getTime() % 5L == 0L) {
                    super.steppedInTime();
                    PlotOrderParameterVsTime.this.sampleData();
                }
            }
        };
    }

    Point2D.Double sampleDataValue() {
        double d = this.getParticleModel().getTime();
        double d2 = this.getParticleModel().getOrderParameter();
        return new Point2D.Double(d, d2);
    }

    private void sampleData() {
        Point2D.Double double_ = this.sampleDataValue();
        this.orderParameterVsTimeChart.addDataPoint(((Point2D)double_).getX(), ((Point2D)double_).getY());
    }

    private void startDataTaking() {
        this.getParticleModel().resetTime();
        this.getParticleModel().addListener(this.listener);
    }

    private void stopTakingData() {
        this.getParticleModel().removeListener(this.listener);
    }

    protected boolean isOrderParamaterAwesome() {
        return false;
    }

    public void init() {
        super.init();
        this.plotButton.setOffset(this.getLocationBeneath(this.getOrderParamText()));
        this.addChild(this.plotButton);
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.plotButton);
        this.tutorialChartFrame.setVisible(false);
        this.stopTakingData();
    }

    public Point2D getLocationBeneath(PNode pNode) {
        return new Point2D.Double(pNode.getFullBounds().getX(), pNode.getFullBounds().getMaxY() + this.getDy());
    }

    private void showPlot() {
        this.tutorialChartFrame.setVisible(true);
    }
}

