/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.selfdrivenparticlemodel.model.ParticleModel;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.BasicTutorialCanvas;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.TutorialChartFrame;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.OrderParameter90;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.OrderParameterVsRandomnessChart;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class PlotOrderParameterVsRandomness
extends OrderParameter90 {
    private OrderParameterVsRandomnessChart orderParameterVsRandomnessChart;
    private TutorialChartFrame tutorialChartFrame;
    private ParticleModel.Adapter listener;
    private PNode orderPlotPanel;

    public PlotOrderParameterVsRandomness(BasicTutorialCanvas basicTutorialCanvas) {
        super(basicTutorialCanvas);
        this.setText("Here we measure order parameter as a function of the randomness value.  Open the plot to start taking readings.  When there is sufficient data at one randomness value, the mean value is marked with a red square.  Take readings at several randomness values, and I'll connect the means.");
        this.orderPlotPanel = new PSwing(new OrderPlotPanel());
        this.orderParameterVsRandomnessChart = new OrderParameterVsRandomnessChart(25000);
        this.tutorialChartFrame = new TutorialChartFrame("Plot", this.orderParameterVsRandomnessChart.getChart(), this.getBasePage().getTutorialApplication().getTutorialFrame());
        this.listener = new ParticleModel.Adapter(){

            public void steppedInTime() {
                if (PlotOrderParameterVsRandomness.this.getParticleModel().getTime() % 4L == 0L) {
                    super.steppedInTime();
                    PlotOrderParameterVsRandomness.this.sampleData();
                }
            }
        };
    }

    Point2D.Double sampleDataValue() {
        double d = this.getParticleModel().getRandomness();
        double d2 = this.getParticleModel().getOrderParameter();
        return new Point2D.Double(d, d2);
    }

    private void sampleData() {
        Point2D.Double double_ = this.sampleDataValue();
        if (this.isLegal(double_)) {
            this.orderParameterVsRandomnessChart.addDataPoint(((Point2D)double_).getX(), ((Point2D)double_).getY());
        }
    }

    private boolean isLegal(Point2D point2D) {
        return this.isLegal(point2D.getX()) && this.isLegal(point2D.getY());
    }

    private boolean isLegal(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    private void startDataTaking() {
        this.getParticleModel().resetTime();
        this.getParticleModel().addListener(this.listener);
    }

    private void stopTakingData() {
        this.getParticleModel().removeListener(this.listener);
    }

    protected boolean isOrderParamaterAwesome() {
        return false;
    }

    public void init() {
        super.init();
        this.orderPlotPanel.setOffset(this.getLocationBeneath(this.getOrderParamText()));
        this.addChild(this.orderPlotPanel);
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.orderPlotPanel);
        this.tutorialChartFrame.setVisible(false);
        this.stopTakingData();
    }

    private void showPlot() {
        this.tutorialChartFrame.setVisible(true);
    }

    protected boolean advanceWhenStartData() {
        return true;
    }

    public PNode getBottomComponent() {
        return this.orderPlotPanel;
    }

    class OrderPlotPanel
    extends HorizontalLayoutPanel {
        public OrderPlotPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Order Plot"));
            JButton jButton = new JButton("Show");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlotOrderParameterVsRandomness.this.showPlot();
                    PlotOrderParameterVsRandomness.this.startDataTaking();
                    if (PlotOrderParameterVsRandomness.this.advanceWhenStartData()) {
                        PlotOrderParameterVsRandomness.this.advance();
                    }
                }
            });
            JButton jButton2 = new JButton("Reset");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlotOrderParameterVsRandomness.this.orderParameterVsRandomnessChart.reset();
                }
            });
            this.add(jButton);
            this.add(jButton2);
        }
    }
}

