/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.selfdrivenparticlemodel.model.ParticleModel;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.BasicTutorialCanvas;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.TutorialChartFrame;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.BetaChart;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.LinearRegression;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.PlotOrderParameterVsRandomness;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class PlotBeta240
extends PlotOrderParameterVsRandomness {
    private PSwing textComponent;
    private MyButton showBetaPlot;
    private MyButton resetBetaPlot;
    private BetaChart betaChart;
    private TutorialChartFrame chartDialog;
    private ParticleModel.Listener listener;
    private JTextField jTextField;
    private MyButton bestFit;
    private PText betaText;
    private PSwing exponentPlotPanelGraphic;
    Font errorFont = new PhetFont(11, true);
    boolean firstTime = true;

    public PlotBeta240(BasicTutorialCanvas basicTutorialCanvas) {
        super(basicTutorialCanvas);
        this.setText("First, plot the order parameter vs. randomness to determine the critical randomness, then enter that value in the red text box below.  You don't have to be exact, but I can't help you here.  ");
        this.jTextField = new JTextField(20);
        this.jTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                PlotBeta240.this.dataEntered();
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.jTextField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.red), "Critical Randomness"));
        this.textComponent = new PSwing(this.jTextField);
        this.showBetaPlot = new MyButton(basicTutorialCanvas, "Show");
        this.showBetaPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotBeta240.this.showBetaPlot();
            }
        });
        this.resetBetaPlot = new MyButton(basicTutorialCanvas, "Reset");
        this.resetBetaPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotBeta240.this.resetBetaPlot();
            }
        });
        this.betaChart = new BetaChart(100000);
        this.chartDialog = new TutorialChartFrame("Plot", this.betaChart.getChart(), this.getBasePage().getTutorialApplication().getTutorialFrame()){};
        this.chartDialog.setLocation(0, 400);
        this.listener = new ParticleModel.Adapter(){

            public void steppedInTime() {
                if (PlotBeta240.this.getParticleModel().getTime() % 4L == 0L) {
                    super.steppedInTime();
                    PlotBeta240.this.sampleBetaData();
                }
            }
        };
        this.bestFit = new MyButton(basicTutorialCanvas, "Linear Fit");
        this.bestFit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotBeta240.this.doBestFit();
                PlotBeta240.this.advance();
            }
        });
        this.betaText = new PText("");
        this.betaText.setFont(new PhetFont(16, true));
        this.betaText.setTextPaint(Color.red);
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        horizontalLayoutPanel.setBorder(BorderFactory.createTitledBorder("Critical Exponent Plot"));
        horizontalLayoutPanel.add(this.showBetaPlot);
        horizontalLayoutPanel.add(this.resetBetaPlot);
        horizontalLayoutPanel.add(this.bestFit);
        this.exponentPlotPanelGraphic = new PSwing(horizontalLayoutPanel);
    }

    private void doBestFit() {
        XYSeries xYSeries = this.betaChart.getMeanDataSet();
        final ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (int i = 0; i < xYSeries.getItemCount(); ++i) {
            XYDataItem xYDataItem = xYSeries.getDataItem(i);
            arrayList.add(new Point2D.Double(xYDataItem.getX().doubleValue(), xYDataItem.getY().doubleValue()));
        }
        LinearRegression.Result result = LinearRegression.main(new LinearRegression.Input(){

            public boolean isEmpty() {
                return arrayList.isEmpty();
            }

            public Point2D readPoint() {
                return (Point2D)arrayList.remove(0);
            }
        });
        double d = this.getMinX(xYSeries);
        double d2 = this.getMaxX(xYSeries);
        Point2D.Double double_ = new Point2D.Double(d, result.evaluate(d));
        Point2D.Double double_2 = new Point2D.Double(d2, result.evaluate(d2));
        this.betaChart.showLine(double_, double_2);
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        this.betaText.setText("Critical Exponent = " + decimalFormat.format(result.getSlope()));
    }

    private double getMaxX(XYSeries xYSeries) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < xYSeries.getItemCount(); ++i) {
            double d2 = xYSeries.getDataItem(i).getX().doubleValue();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private double getMinX(XYSeries xYSeries) {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < xYSeries.getItemCount(); ++i) {
            double d2 = xYSeries.getDataItem(i).getX().doubleValue();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    double ln(double d) {
        return Math.log(d) / Math.log(Math.E);
    }

    Point2D.Double sampleBetaDataValue() throws NoEtaCriticalException {
        double d = this.getParticleModel().getOrderParameter();
        double d2 = this.getParticleModel().getRandomness();
        double d3 = 0.0;
        d3 = this.getEtaCritical();
        double d4 = (d3 - d2) / d3;
        double d5 = this.ln(d4);
        double d6 = this.ln(d);
        return new Point2D.Double(d5, d6);
    }

    private double getEtaCritical() throws NoEtaCriticalException {
        try {
            double d = Double.parseDouble(this.jTextField.getText());
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new NoEtaCriticalException();
        }
    }

    private void sampleBetaData() {
        Point2D.Double double_ = null;
        try {
            double_ = this.sampleBetaDataValue();
            if (Double.isNaN(((Point2D)double_).getX()) || Double.isNaN(((Point2D)double_).getY()) || Double.isInfinite(((Point2D)double_).getX()) || Double.isInfinite(((Point2D)double_).getY())) {
                this.chartDialog.getContentPane().repaint();
            } else {
                this.betaChart.addDataPoint(((Point2D)double_).getX(), ((Point2D)double_).getY());
            }
        }
        catch (NoEtaCriticalException noEtaCriticalException) {
            // empty catch block
        }
    }

    private void showBetaPlot() {
        this.chartDialog.show();
        this.getParticleModel().addListener(this.listener);
    }

    private void resetBetaPlot() {
        this.betaChart.reset();
    }

    private void dataEntered() {
        if (this.firstTime) {
            this.firstTime = false;
            this.playHarp();
            this.append("  Good!  Now you can determine the critical exponent.  Show the Critical Exponent Plot, take additional readings at different randomness values, and I'll apply the logarithms.  When you have enough data, you can press 'Linear Fit' to compute the critical exponent.");
            this.showBetaStuff();
        }
    }

    private void showBetaStuff() {
        this.exponentPlotPanelGraphic.setOffset(this.getLocationBeneath(this.textComponent));
        this.addChild(this.exponentPlotPanelGraphic);
        this.betaText.setOffset(this.getLocationBeneath(this.exponentPlotPanelGraphic));
        this.addChild(this.betaText);
    }

    public void init() {
        super.init();
        this.textComponent.setOffset(this.getLocationBeneath(this.getBottomComponent()));
        this.addChild(this.textComponent);
        if (!this.firstTime) {
            this.showBetaStuff();
        }
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.textComponent);
        this.removeChild(this.exponentPlotPanelGraphic);
        this.removeChild(this.betaText);
        this.getParticleModel().removeListener(this.listener);
        this.chartDialog.setVisible(false);
    }

    protected boolean advanceWhenStartData() {
        return false;
    }

    static class MyButton
    extends JButton {
        public MyButton(BasicTutorialCanvas basicTutorialCanvas, String string) {
            super(string);
        }
    }

    static class NoEtaCriticalException
    extends Exception {
        NoEtaCriticalException() {
        }
    }
}

