/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2;

import java.awt.BasicStroke;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class OrderParameterVsTimeChart {
    private XYSeries meanSeries;
    private XYSeriesCollection xySeriesCollection;
    private NumberAxis domainAxis;
    private NumberAxis rangeAxis;
    private XYLineAndShapeRenderer renderer;
    private XYPlot xyPlot;
    private JFreeChart chart;
    private int maxItemCount;
    private boolean changedToScrolling = false;

    public OrderParameterVsTimeChart(int n) {
        this.maxItemCount = n;
        this.meanSeries = new XYSeries((Comparable)((Object)"Order Parameter vs Time"));
        this.xySeriesCollection = new XYSeriesCollection(this.meanSeries);
        this.domainAxis = new NumberAxis("Time");
        this.rangeAxis = new NumberAxis("Order Parameter");
        this.renderer = new XYLineAndShapeRenderer();
        int n2 = 0;
        this.renderer.setSeriesStroke(n2, new BasicStroke(2.0f));
        this.renderer.setSeriesLinesVisible(n2, true);
        this.renderer.setSeriesShapesVisible(n2, false);
        this.xyPlot = new XYPlot(this.xySeriesCollection, this.domainAxis, this.rangeAxis, this.renderer);
        this.chart = new JFreeChart("Order Parameter vs. Time", this.xyPlot);
        this.rangeAxis.setRange(-0.01, 1.01);
        this.domainAxis.setAutoRange(false);
        this.domainAxis.setRange(0.0, (long)n * 5L);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void addDataPoint(double d, double d2) {
        this.meanSeries.add(d, d2);
        while (this.meanSeries.getItemCount() > this.maxItemCount) {
            this.changeToScrolling();
            this.meanSeries.remove(0);
        }
        this.domainAxis.configure();
    }

    private void changeToScrolling() {
        if (!this.changedToScrolling) {
            this.changedToScrolling = true;
            this.domainAxis.setAutoRange(true);
            this.domainAxis.setAutoRangeIncludesZero(false);
        }
    }
}

