/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.BasicTutorialCanvas;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit1.FullFeatureBaseClass;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.text.DecimalFormat;

public class OrderParameter90
extends FullFeatureBaseClass {
    private PText orderParamText;
    private DecimalFormat decimalFormat;
    private PActivity activity;

    public OrderParameter90(BasicTutorialCanvas basicTutorialCanvas) {
        super(basicTutorialCanvas);
        this.setText("Some Dynamical Systems can be characterized by their degree of orderliness.  This quantity is termed the 'order parameter'.  In this model, the order parameter reflects the similarity of particles' headings.  Try to get the order parameter above 0.9");
        this.orderParamText = new PText();
        this.orderParamText.setTextPaint(Color.blue);
        this.orderParamText.setFont(new PhetFont(16, true));
        this.decimalFormat = new DecimalFormat("0.00");
        this.activity = new PActivity(-1L){

            protected void activityStep(long l) {
                super.activityStep(l);
                OrderParameter90.this.updateText();
                if (OrderParameter90.this.isOrderParamaterAwesome()) {
                    OrderParameter90.this.advance();
                }
            }
        };
    }

    private void updateText() {
        this.orderParamText.setText("Order Parameter = " + this.decimalFormat.format(this.getParticleModel().getOrderParameter()));
    }

    public PText getOrderParamText() {
        return this.orderParamText;
    }

    protected boolean isOrderParamaterAwesome() {
        return this.getParticleModel().getOrderParameter() > 0.9;
    }

    public void init() {
        super.init();
        this.getBasePage().createUniverse();
        this.getBasePage().setNumberParticles(20);
        this.getBasePage().getParticleModel().setRandomness(this.getInitRandomness());
        this.updateText();
        this.orderParamText.setOffset(this.getRadiusControlGraphic().getFullBounds().getX(), this.getRadiusControlGraphic().getFullBounds().getMaxY() + super.getDy());
        this.orderParamText.recomputeLayout();
        this.addChild(this.orderParamText);
        this.getBasePage().getRoot().addActivity(this.activity);
        this.startModel();
    }

    protected double getInitRandomness() {
        return 1.0;
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.orderParamText);
        this.getBasePage().getRoot().getActivityScheduler().removeActivity(this.activity);
    }
}

