/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2;

import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.MyMultiMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class BetaChart {
    private XYSeries meanSeries;
    private XYSeriesCollection xySeriesCollection;
    private NumberAxis domainAxis;
    private NumberAxis rangeAxis;
    private XYLineAndShapeRenderer renderer;
    private XYPlot xyPlot;
    private JFreeChart chart;
    private int maxItemCount;
    private XYSeries lineSeries;
    private XYSeries bestFitSeries;

    public BetaChart(int n) {
        this.maxItemCount = n;
        this.meanSeries = new XYSeries((Comparable)((Object)"Raw Data"));
        this.lineSeries = new XYSeries((Comparable)((Object)"Mean Values"));
        this.bestFitSeries = new XYSeries((Comparable)((Object)"Best Fit"));
        this.xySeriesCollection = new XYSeriesCollection(this.meanSeries);
        this.xySeriesCollection.addSeries(this.lineSeries);
        this.xySeriesCollection.addSeries(this.bestFitSeries);
        this.domainAxis = new NumberAxis("ln[(c-r)/c]");
        this.rangeAxis = new NumberAxis("ln(Order Parameter)");
        this.renderer = new XYLineAndShapeRenderer();
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        this.renderer.setSeriesShape(n2, new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        this.renderer.setSeriesShape(n3, new Rectangle(-4, -4, 8, 8));
        this.renderer.setSeriesLinesVisible(n2, false);
        this.renderer.setSeriesShapesVisible(n2, true);
        Color color = new Color(0, 0, 255, 14);
        this.renderer.setSeriesPaint(n2, color);
        this.renderer.setSeriesItemLabelPaint(n2, color);
        this.renderer.setSeriesOutlinePaint(n2, color);
        this.renderer.setSeriesLinesVisible(n3, true);
        this.renderer.setSeriesLinesVisible(n4, true);
        this.renderer.setSeriesShapesVisible(n4, false);
        this.renderer.setSeriesStroke(n4, new BasicStroke(2.0f));
        this.renderer.setSeriesPaint(n4, Color.green);
        this.xyPlot = new XYPlot(this.xySeriesCollection, this.domainAxis, this.rangeAxis, this.renderer);
        this.chart = new JFreeChart("Critical Exponent Log Plot", this.xyPlot);
        this.rangeAxis.setAutoRange(true);
        this.rangeAxis.setAutoRangeIncludesZero(false);
        this.domainAxis.setAutoRange(true);
        this.domainAxis.setAutoRangeIncludesZero(false);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void addDataPoint(double d, double d2) {
        this.meanSeries.add(d, d2);
        while (this.meanSeries.getItemCount() > this.maxItemCount) {
            this.meanSeries.remove(0);
        }
        this.domainAxis.configure();
        this.updateLines();
    }

    private void updateLines() {
        Cloneable cloneable;
        MyMultiMap myMultiMap = new MyMultiMap();
        for (int i = 0; i < this.meanSeries.getItemCount(); ++i) {
            cloneable = this.meanSeries.getDataItem(i);
            myMultiMap.add(((XYDataItem)cloneable).getX(), ((XYDataItem)cloneable).getY());
        }
        Set set = myMultiMap.keySet();
        cloneable = new ArrayList(set);
        Collections.sort(cloneable, new Comparator(){

            public int compare(Object object, Object object2) {
                Number number = (Number)object;
                Number number2 = (Number)object2;
                return Double.compare(number.doubleValue(), number2.doubleValue());
            }
        });
        this.lineSeries.clear();
        for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
            Number number = (Number)((ArrayList)cloneable).get(i);
            int n = myMultiMap.numValues(number);
            if (n <= 14) continue;
            this.lineSeries.add(number.doubleValue(), this.average(myMultiMap.getList(number)));
        }
    }

    private double average(List list) {
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Number number = (Number)list.get(i);
            d += number.doubleValue();
        }
        return d / (double)list.size();
    }

    public void reset() {
        this.lineSeries.clear();
        this.meanSeries.clear();
        this.bestFitSeries.clear();
    }

    public XYSeries getMeanDataSet() {
        return this.meanSeries;
    }

    public void showLine(Point2D point2D, Point2D point2D2) {
        this.bestFitSeries.clear();
        this.bestFitSeries.add(point2D.getX(), point2D.getY());
        this.bestFitSeries.add(point2D2.getX(), point2D2.getY());
    }
}

