/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit1;

import edu.colorado.phet.selfdrivenparticlemodel.tutorial.BasicTutorialCanvas;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.Page;
import edu.colorado.phet.selfdrivenparticlemodel.view.InteractionRadiusControl;
import edu.colorado.phet.selfdrivenparticlemodel.view.NumberSliderPanel;
import edu.colorado.phet.selfdrivenparticlemodel.view.RandomnessSlider;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class FullFeatureBaseClass
extends Page {
    protected PSwing checkBoxGraphic;
    protected PSwing randomnessGraphic;
    protected PSwing particleCountGraphic;
    protected PSwing radiusControlGraphic;
    private NumberSliderPanel numberSliderPanel;

    public FullFeatureBaseClass(final BasicTutorialCanvas basicTutorialCanvas) {
        super(basicTutorialCanvas);
        final JCheckBox jCheckBox = new JCheckBox("Show Range", basicTutorialCanvas.isHalosVisible());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                basicTutorialCanvas.setHalosVisible(jCheckBox.isSelected());
            }
        });
        this.checkBoxGraphic = new PSwing(jCheckBox);
        RandomnessSlider randomnessSlider = new RandomnessSlider(this.getParticleModel());
        this.randomnessGraphic = new PSwing(randomnessSlider);
        this.numberSliderPanel = new NumberSliderPanel(basicTutorialCanvas, 0, 50, 1, new int[]{0, 10, 20, 30, 40, 50});
        this.particleCountGraphic = new PSwing(this.numberSliderPanel);
        InteractionRadiusControl interactionRadiusControl = new InteractionRadiusControl(this.getParticleModel());
        this.radiusControlGraphic = new PSwing(interactionRadiusControl);
    }

    public NumberSliderPanel getNumberSliderPanel() {
        return this.numberSliderPanel;
    }

    public void init() {
        super.init();
        this.checkBoxGraphic.setOffset(this.getBasePage().getPreviousButton().getFullBounds().getX(), this.getBasePage().getPreviousButton().getFullBounds().getMaxY());
        this.randomnessGraphic.setOffset(this.checkBoxGraphic.getFullBounds().getX(), this.checkBoxGraphic.getFullBounds().getMaxY() + this.getDy());
        this.particleCountGraphic.setOffset(this.randomnessGraphic.getFullBounds().getX(), this.randomnessGraphic.getFullBounds().getMaxY() + this.getDy());
        this.radiusControlGraphic.setOffset(this.particleCountGraphic.getFullBounds().getX(), this.particleCountGraphic.getFullBounds().getMaxY() + this.getDy());
        this.addChild(this.checkBoxGraphic);
        this.addChild(this.randomnessGraphic);
        this.addChild(this.particleCountGraphic);
        this.addChild(this.radiusControlGraphic);
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.checkBoxGraphic);
        this.removeChild(this.randomnessGraphic);
        this.removeChild(this.particleCountGraphic);
        this.removeChild(this.radiusControlGraphic);
    }

    public PSwing getRandomnessGraphic() {
        return this.randomnessGraphic;
    }

    public PSwing getParticleCountGraphic() {
        return this.particleCountGraphic;
    }

    public PSwing getRadiusControlGraphic() {
        return this.radiusControlGraphic;
    }
}

