/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial;

import edu.colorado.phet.selfdrivenparticlemodel.model.ParticleModel;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.BasicTutorialCanvas;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.PButton;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.TutorialChartFrame;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.OrderParameterVsTimeChart;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit2.PlotBeta240;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JCheckBox;

public class FullExperimentPage
extends PlotBeta240 {
    private PButton plotButton;
    private OrderParameterVsTimeChart orderParameterVsTimeChart;
    private TutorialChartFrame tutorialChartFrame;
    private ParticleModel.Adapter listener;
    private PText clusterCountGraphic;
    private PSwing clusterCheckbox;
    private PActivity clusterCountActivity;
    private PButton randomize;
    private PButton applauseButton;

    public FullExperimentPage(BasicTutorialCanvas basicTutorialCanvas) {
        super(basicTutorialCanvas);
        this.setText("On this page, you can experiment with the Self-Driven Particle Model as you wish.  Here you can have up to 200 particles, display a cluster # indicator, and easily reset the particles.\n\nThis page concludes the tutorial, so you are entitled to applause.");
        this.plotButton = new PButton(basicTutorialCanvas, "Plot Order Parameter vs Time");
        this.plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FullExperimentPage.this.showPlot();
                FullExperimentPage.this.startDataTaking();
                FullExperimentPage.this.advance();
            }
        });
        this.orderParameterVsTimeChart = new OrderParameterVsTimeChart(125);
        this.tutorialChartFrame = new TutorialChartFrame("Plot", this.orderParameterVsTimeChart.getChart(), this.getBasePage().getTutorialApplication().getTutorialFrame());
        this.listener = new ParticleModel.Adapter(){

            public void steppedInTime() {
                if (FullExperimentPage.this.getParticleModel().getTime() % 4L == 0L) {
                    super.steppedInTime();
                    FullExperimentPage.this.sampleData();
                }
            }
        };
        final JCheckBox jCheckBox = new JCheckBox("Show Cluster Count", false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBox.isSelected()) {
                    FullExperimentPage.this.getParticleModel().setComputeClusterCount(true);
                    FullExperimentPage.this.addChild(FullExperimentPage.this.clusterCountGraphic);
                    FullExperimentPage.this.getBasePage().getRoot().addActivity(FullExperimentPage.this.clusterCountActivity);
                } else {
                    FullExperimentPage.this.getParticleModel().setComputeClusterCount(false);
                    FullExperimentPage.this.removeChild(FullExperimentPage.this.clusterCountGraphic);
                    FullExperimentPage.this.getBasePage().getRoot().getActivityScheduler().removeActivity(FullExperimentPage.this.clusterCountActivity);
                }
            }
        });
        this.clusterCheckbox = new PSwing(jCheckBox);
        this.clusterCountGraphic = new PText("");
        this.clusterCountGraphic.setOffset(this.getUniverseGraphic().getFullBounds().getX() + 4.0, this.getUniverseGraphic().getFullBounds().getY() + 4.0);
        this.clusterCountActivity = new PActivity(-1L){

            protected void activityStep(long l) {
                super.activityStep(l);
                FullExperimentPage.this.clusterCountGraphic.setText("# Clusters: " + FullExperimentPage.this.getParticleModel().getNumClusters());
            }
        };
        this.getNumberSliderPanel().setMaxNumber(200);
        this.getNumberSliderPanel().getModelSlider().setModelTicks(new double[]{0.0, 50.0, 100.0, 150.0, 200.0});
        this.randomize = new PButton(basicTutorialCanvas, "Randomize");
        this.randomize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FullExperimentPage.this.randomize();
            }
        });
        this.applauseButton = new PButton(basicTutorialCanvas, "Applause");
        this.applauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FullExperimentPage.this.playApplause();
            }
        });
    }

    void randomize() {
        this.getParticleModel().randomize();
    }

    private void showPlot() {
        this.tutorialChartFrame.setVisible(true);
    }

    Point2D.Double sampleDataValue() {
        double d = this.getParticleModel().getTime();
        double d2 = this.getParticleModel().getOrderParameter();
        return new Point2D.Double(d, d2);
    }

    private void sampleData() {
        Point2D.Double double_ = this.sampleDataValue();
        this.orderParameterVsTimeChart.addDataPoint(((Point2D)double_).getX(), ((Point2D)double_).getY());
    }

    private void startDataTaking() {
        this.getParticleModel().resetTime();
        this.getParticleModel().addListener(this.listener);
    }

    protected void showNextButton() {
    }

    public void init() {
        super.init();
        this.plotButton.setOffset(this.getUniverseGraphic().getFullBounds().getX(), this.getUniverseGraphic().getFullBounds().getMaxY());
        this.addChild(this.plotButton);
        this.clusterCheckbox.setOffset(this.plotButton.getFullBounds().getMaxX(), this.plotButton.getFullBounds().getY());
        this.addChild(this.clusterCheckbox);
        this.randomize.setOffset(this.clusterCheckbox.getFullBounds().getMaxX(), this.clusterCheckbox.getFullBounds().getY());
        this.addChild(this.randomize);
        this.applauseButton.setOffset(this.randomize.getFullBounds().getMaxX(), this.randomize.getFullBounds().getY());
        this.addChild(this.applauseButton);
        this.playApplause();
    }

    protected void showFinishText() {
    }

    protected void append(String string) {
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.plotButton);
        this.removeChild(this.clusterCheckbox);
        this.removeChild(this.randomize);
        this.removeChild(this.applauseButton);
    }

    protected void advance() {
    }
}

