/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.selfdrivenparticlemodel.model.ClusterAssignment;
import edu.colorado.phet.selfdrivenparticlemodel.model.Particle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class ParticleModel {
    private ArrayList<Particle> particles = new ArrayList();
    private double radius = 60.0;
    private Random random = new Random();
    private double speed = 5.0;
    private double randomness = Math.PI * 2;
    private double boxWidth;
    private double boxHeight;
    private boolean factorOutNetMovement = false;
    private ArrayList<Listener> listeners = new ArrayList();
    private int maxClusterID;
    private long time;
    private boolean doCountClusters;

    public ParticleModel(double d, double d2) {
        this.boxWidth = d;
        this.boxHeight = d2;
    }

    public void addParticle(Particle particle) {
        this.particles.add(particle);
        this.notifyCountChanged();
    }

    public void step(double d) {
        this.updateAngles();
        this.moveParticles(d);
        if (this.factorOutNetMovement) {
            this.factorOutNetMovement();
        }
        if (this.doCountClusters) {
            int[] nArray = new ClusterAssignment().assignClusters(this);
            Arrays.sort(nArray);
            this.maxClusterID = nArray.length > 0 ? nArray[nArray.length - 1] : -1;
        }
        ++this.time;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = this.listeners.get(i);
            listener.steppedInTime();
        }
    }

    private void factorOutNetMovement() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            d += this.speed * Math.cos(particle.getAngle());
            d2 += this.speed * Math.sin(particle.getAngle());
        }
        this.translateAll(-(d /= (double)this.particles.size()), -(d2 /= (double)this.particles.size()));
    }

    private void translateAll(double d, double d2) {
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            particle.translate(d, d2);
        }
    }

    private void moveParticles(double d) {
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            double d2 = this.speed * Math.cos(particle.getAngle()) * d;
            double d3 = this.speed * Math.sin(particle.getAngle()) * d;
            particle.translate(d2, d3);
        }
        this.wrapParticles();
    }

    private void wrapParticles() {
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            double d = 0.0;
            double d2 = 0.0;
            if (particle.getX() < 0.0) {
                d += this.getBoxWidth();
            }
            if (particle.getY() < 0.0) {
                d2 += this.getBoxHeight();
            }
            if (particle.getX() > this.getBoxWidth()) {
                d -= this.getBoxWidth();
            }
            if (particle.getY() > this.getBoxHeight()) {
                d2 -= this.getBoxHeight();
            }
            particle.translate(d, d2);
        }
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }

    public double getBoxHeight() {
        return this.boxHeight;
    }

    private void updateAngles() {
        int n;
        double[] dArray = new double[this.particles.size()];
        for (n = 0; n < this.particles.size(); ++n) {
            Particle particle = this.particles.get(n);
            Particle[] particleArray = this.getNeighborsInRadius(particle);
            dArray[n] = this.getNewAngle(particle, particleArray);
        }
        for (n = 0; n < dArray.length; ++n) {
            double d = dArray[n];
            this.particleAt(n).setAngle(d);
        }
    }

    public Particle particleAt(int n) {
        return this.particles.get(n);
    }

    public long getTime() {
        return this.time;
    }

    private double getNewAngle(Particle particle, Particle[] particleArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < particleArray.length; ++i) {
            Particle particle2 = particleArray[i];
            d += Math.cos(particle2.getAngle());
            d2 += Math.sin(particle2.getAngle());
        }
        double d3 = Math.atan2(d2, d);
        d3 = this.addRandomness(d3);
        return d3;
    }

    private double addRandomness(double d) {
        double d2 = this.random.nextDouble() * this.randomness - this.randomness / 2.0;
        return d2 + d;
    }

    public Particle[] getNeighborsInRadius(Particle particle) {
        return this.getNeighborsInRadius(particle, this.radius);
    }

    private Particle[] getNeighborsInRadius(Particle particle, double d) {
        ArrayList<Particle> arrayList = new ArrayList<Particle>();
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle2 = this.particles.get(i);
            if (!(particle2.distance(particle) <= d)) continue;
            arrayList.add(particle2);
        }
        return arrayList.toArray(new Particle[0]);
    }

    public int numParticles() {
        return this.particles.size();
    }

    public double getRandomness() {
        return this.randomness;
    }

    public void setRandomness(double d) {
        if (this.randomness != d) {
            this.randomness = d;
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = this.listeners.get(i);
                listener.randomnessChanged();
            }
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        if (this.radius != d) {
            this.radius = d;
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = this.listeners.get(i);
                listener.radiusChanged();
            }
        }
    }

    public int indexOf(Particle particle) {
        return this.particles.indexOf(particle);
    }

    public void removeParticle(Particle particle) {
        this.particles.remove(particle);
        this.notifyCountChanged();
    }

    private void notifyCountChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = this.listeners.get(i);
            listener.particleCountChanged();
        }
    }

    public Particle lastParticle() {
        return this.particleAt(this.numParticles() - 1);
    }

    public int getNumClusters() {
        return this.maxClusterID + 1;
    }

    public void randomize() {
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            particle.setAngle(this.random.nextDouble() * Math.PI * 2.0);
            particle.setLocation(this.random.nextDouble() * this.boxWidth, this.random.nextDouble() * this.boxHeight);
        }
    }

    public void removeListener(Listener listener) {
        while (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void resetTime() {
        this.time = 0L;
    }

    public void setComputeClusterCount(boolean bl) {
        this.doCountClusters = bl;
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public double getOrderParameter() {
        MutableVector2D mutableVector2D = new MutableVector2D();
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            Vector2D vector2D = this.getVelocity(particle);
            mutableVector2D.add(vector2D);
        }
        return mutableVector2D.magnitude() / (double)this.numParticles() / this.speed;
    }

    private Vector2D getVelocity(Particle particle) {
        return MutableVector2D.createPolar(this.speed, particle.getAngle());
    }

    public static class Adapter
    implements Listener {
        public void radiusChanged() {
        }

        public void randomnessChanged() {
        }

        public void steppedInTime() {
        }

        public void particleCountChanged() {
        }
    }

    public static interface Listener {
        public void radiusChanged();

        public void randomnessChanged();

        public void steppedInTime();

        public void particleCountChanged();
    }
}

