/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel;

import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.EmergenceUnit;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.FinalUnit;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.TitleScreen;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.TutorialFrame;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.Unit;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit1.IntroductionUnit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SelfDrivenParticleModelApplication {
    TutorialFrame tutorialFrame;
    TitleScreen titleScreen;
    ArrayList units = new ArrayList();
    private Unit currentUnit;
    private int currentUnitIndex = 0;
    private TutorialKeyHandler keyHandler;

    public SelfDrivenParticleModelApplication() {
        this.tutorialFrame = new TutorialFrame(this);
        this.keyHandler = new TutorialKeyHandler();
        if (SelfDrivenParticleModelApplication.isLowResolution()) {
            this.tutorialFrame.setSize(800, 680);
        } else {
            this.tutorialFrame.setSize(800, 825);
        }
        this.titleScreen = new TitleScreen(this);
        this.tutorialFrame.setContentPane(this.titleScreen);
        SelfDrivenParticleModelApplication.centerWindowOnScreen(this.tutorialFrame);
        IntroductionUnit introductionUnit = new IntroductionUnit(this);
        this.units.add(introductionUnit);
        EmergenceUnit emergenceUnit = new EmergenceUnit(this);
        this.units.add(emergenceUnit);
        FinalUnit finalUnit = new FinalUnit(this);
        this.units.add(finalUnit);
        this.titleScreen.addKeyListener(this.keyHandler);
    }

    public KeyListener getKeyHandler() {
        return this.keyHandler;
    }

    public boolean isFirstUnit() {
        return this.currentUnitIndex == 0;
    }

    private void moveLeft() {
        if (this.currentUnit != null) {
            this.currentUnit.moveLeft();
        }
    }

    private void moveRight() {
        if (this.currentUnit != null) {
            this.currentUnit.moveRight();
        }
    }

    public static void centerWindowOnScreen(Window window) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        window.setLocation((int)(dimension.getWidth() / 2.0 - (double)(window.getWidth() / 2)), 0);
    }

    public static boolean isLowResolution() {
        return Toolkit.getDefaultToolkit().getScreenSize().height <= 768;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new PhetLookAndFeel().initLookAndFeel();
                new SelfDrivenParticleModelApplication().start();
            }
        });
    }

    private void start() {
        this.tutorialFrame.show();
        this.titleScreen.requestFocus();
    }

    public void startTutorial() {
        this.setUnit(0);
    }

    private void setUnit(int n) {
        this.currentUnitIndex = n;
        if (this.currentUnit != null) {
            this.currentUnit.teardown(this);
        }
        this.unitAt(n).start(this);
        this.currentUnit = this.unitAt(n);
    }

    private Unit unitAt(int n) {
        return (Unit)this.units.get(n);
    }

    public void setContentPane(JComponent jComponent) {
        this.tutorialFrame.setContentPane(jComponent);
        this.fixit(this.tutorialFrame.getContentPane());
        this.fixit(this.tutorialFrame);
    }

    private void fixit(Component component) {
        component.invalidate();
        component.validate();
        component.doLayout();
        component.repaint();
    }

    public TutorialFrame getTutorialFrame() {
        return this.tutorialFrame;
    }

    public void nextUnit() {
        this.setUnit(this.currentUnitIndex + 1);
    }

    public void previousUnit() {
        if (this.currentUnitIndex == 0) {
            return;
        }
        this.setUnit(this.currentUnitIndex - 1);
    }

    public class TutorialKeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 50 || keyEvent.getKeyCode() == 98) {
                SelfDrivenParticleModelApplication.this.setUnit(1);
            }
            if (keyEvent.getKeyCode() == 49 || keyEvent.getKeyCode() == 97) {
                SelfDrivenParticleModelApplication.this.setUnit(0);
            }
            if (keyEvent.getKeyCode() == 51 || keyEvent.getKeyCode() == 99) {
                SelfDrivenParticleModelApplication.this.setUnit(2);
            }
            if (keyEvent.getKeyCode() == 39) {
                SelfDrivenParticleModelApplication.this.moveRight();
            } else if (keyEvent.getKeyCode() == 37) {
                SelfDrivenParticleModelApplication.this.moveLeft();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

