/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.energy;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeB;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.model.reactions.A_BC_AB_C_Reaction;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.view.EnergyMoleculeGraphic;
import edu.colorado.phet.reactionsandrates.view.SeparationIndicatorArrow;
import edu.colorado.phet.reactionsandrates.view.energy.CurvePane;
import edu.colorado.phet.reactionsandrates.view.energy.MoleculeSelectionTracker;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MoleculeSeparationPane
extends PPath {
    private final MoleculeSelectionTracker tracker;
    private final PNode selectedMoleculeGraphic = new PNode();
    private final PNode nearestToSelectedMoleculeGraphic = new PNode();
    private Insets paneInsets = new Insets(20, 30, 40, 10);
    private PNode moleculePaneAxisNode;
    private SeparationIndicatorArrow separationIndicatorArrow;
    private CurvePane curvePane;
    private PNode moleculeLayer;
    private MoleculeGraphicController moleculeGraphicController;
    private MRModule module;
    private UpdatingClockListener updatingClockListener;

    public MoleculeSeparationPane(MRModule mRModule, Dimension dimension, CurvePane curvePane) {
        super(new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight()));
        this.module = mRModule;
        this.curvePane = curvePane;
        this.setPaint(MRConfig.MOLECULE_PANE_BACKGROUND);
        this.moleculeLayer = new PNode();
        this.moleculeLayer.setOffset(this.paneInsets.left, 0.0);
        this.addChild(this.moleculeLayer);
        this.moleculePaneAxisNode = new PNode();
        this.separationIndicatorArrow = new SeparationIndicatorArrow(Color.black);
        this.moleculePaneAxisNode.addChild(this.separationIndicatorArrow);
        PText pText = new PText(MRConfig.RESOURCES.getLocalizedString("EnergyView.separation"));
        pText.setFont(MRConfig.LABEL_FONT);
        pText.rotate(-1.5707963267948966);
        pText.setOffset((double)(this.paneInsets.left / 2) - pText.getFullBounds().getWidth() + 2.0, this.getFullBounds().getHeight() / 2.0 + pText.getFullBounds().getHeight() / 2.0);
        this.moleculePaneAxisNode.addChild(pText);
        this.moleculePaneAxisNode.setVisible(false);
        this.addChild(this.moleculePaneAxisNode);
        this.tracker = new MoleculeSelectionTracker(mRModule);
        this.moleculeGraphicController = new MoleculeGraphicController(mRModule);
        this.updatingClockListener = new UpdatingClockListener();
        this.moleculeLayer.addChild(this.selectedMoleculeGraphic);
        this.moleculeLayer.addChild(this.nearestToSelectedMoleculeGraphic);
        mRModule.getClock().addClockListener(this.updatingClockListener);
    }

    public MoleculeSelectionTracker getTracker() {
        return this.tracker;
    }

    public void reset() {
        this.tracker.reset();
    }

    public void terminate() {
        this.tracker.terminate();
        this.module.getClock().removeClockListener(this.updatingClockListener);
    }

    public void update() {
        this.moleculeGraphicController.update();
        this.updateEnergyCursorVisibility();
        this.updateMoleculePaneAxis();
    }

    private void updateEnergyCursorVisibility() {
        this.curvePane.setEnergyCursorVisible(this.getTracker().getSelectedMolecule() != null);
    }

    private void updateMoleculePaneAxis() {
        this.moleculePaneAxisNode.setVisible(this.tracker.getSelectedMolecule() != null);
    }

    private class MoleculeGraphicController
    implements SimpleObserver {
        private final MRModule module;
        private int direction;
        private double yMin;
        private double yMax;
        private Point2D.Double midPoint = new Point2D.Double(0.0, 0.0);

        public MoleculeGraphicController(MRModule mRModule) {
            this.module = mRModule;
        }

        public void update() {
            this.updateDirection();
            this.updatePositions();
            this.updateMoleculeGraphics();
            this.updateSeparationArrow();
            this.updateEnergyCursor();
        }

        private boolean shouldDrawMoleculeOnTop(AbstractMolecule abstractMolecule) {
            if (abstractMolecule == null) {
                return false;
            }
            if (abstractMolecule.getClass() == MoleculeA.class) {
                return true;
            }
            if (abstractMolecule.isComposite()) {
                if (abstractMolecule.getComponentMolecules()[0].getClass() == MoleculeA.class) {
                    return true;
                }
                if (abstractMolecule.getComponentMolecules()[1].getClass() == MoleculeA.class) {
                    return true;
                }
            }
            return false;
        }

        private void addMoleculeGraphic(PNode pNode, AbstractMolecule abstractMolecule, boolean bl) {
            pNode.removeAllChildren();
            if (abstractMolecule != null) {
                EnergyMoleculeGraphic energyMoleculeGraphic = new EnergyMoleculeGraphic(abstractMolecule.getFullMolecule(), this.module.getMRModel().getEnergyProfile());
                energyMoleculeGraphic.translate(this.midPoint.getX(), bl ? this.yMin : this.yMax);
                pNode.addChild(energyMoleculeGraphic);
            }
        }

        private void updateMoleculeGraphics() {
            boolean bl = this.shouldDrawMoleculeOnTop(MoleculeSeparationPane.this.tracker.getSelectedMolecule());
            this.addMoleculeGraphic(MoleculeSeparationPane.this.selectedMoleculeGraphic, MoleculeSeparationPane.this.tracker.getSelectedMolecule(), bl);
            this.addMoleculeGraphic(MoleculeSeparationPane.this.nearestToSelectedMoleculeGraphic, MoleculeSeparationPane.this.tracker.getNearestToSelectedMolecule(), !bl);
        }

        private void updateEnergyCursor() {
            MoleculeSeparationPane.this.curvePane.setEnergyCursorOffset(this.midPoint.getX());
        }

        private void updateSeparationArrow() {
            MoleculeSeparationPane.this.separationIndicatorArrow.setEndpoints(((MoleculeSeparationPane)MoleculeSeparationPane.this).paneInsets.left / 2 + 10, this.yMin, ((MoleculeSeparationPane)MoleculeSeparationPane.this).paneInsets.left / 2 + 10, this.yMax);
        }

        private void updateDirection() {
            if (MoleculeSeparationPane.this.tracker.isTracking()) {
                SimpleMolecule simpleMolecule = MoleculeSeparationPane.this.tracker.getFreeMolecule();
                SimpleMolecule simpleMolecule2 = MoleculeSeparationPane.this.tracker.getBoundMolecule();
                assert (simpleMolecule != null);
                assert (simpleMolecule2 != null);
                if (MoleculeSeparationPane.this.tracker.getSelectedMolecule() instanceof MoleculeA && MoleculeSeparationPane.this.tracker.getSelectedMolecule() == simpleMolecule) {
                    this.direction = -1;
                } else if (MoleculeSeparationPane.this.tracker.getSelectedMolecule() instanceof MoleculeA && MoleculeSeparationPane.this.tracker.getSelectedMolecule() == simpleMolecule2) {
                    this.direction = 1;
                } else if (MoleculeSeparationPane.this.tracker.getSelectedMolecule() instanceof MoleculeC && MoleculeSeparationPane.this.tracker.getSelectedMolecule() == simpleMolecule) {
                    this.direction = 1;
                } else if (MoleculeSeparationPane.this.tracker.getSelectedMolecule() instanceof MoleculeC && MoleculeSeparationPane.this.tracker.getSelectedMolecule() == simpleMolecule2) {
                    this.direction = -1;
                } else {
                    throw new RuntimeException("internal error");
                }
            }
        }

        private SimpleMolecule getBMolecule(SimpleMolecule[] simpleMoleculeArray) {
            for (int i = 0; i < simpleMoleculeArray.length; ++i) {
                if (simpleMoleculeArray[i].getClass() != MoleculeB.class) continue;
                return simpleMoleculeArray[i];
            }
            return null;
        }

        private SimpleMolecule getFreeOrBMolecule(SimpleMolecule simpleMolecule) {
            if (simpleMolecule.isPartOfComposite()) {
                simpleMolecule = this.getBMolecule(simpleMolecule.getFullMolecule().getComponentMolecules());
            } else if (simpleMolecule.isComposite()) {
                simpleMolecule = this.getBMolecule(simpleMolecule.getComponentMolecules());
            }
            return simpleMolecule;
        }

        public SimpleMolecule getNearestComponentToSelectedMolecule() {
            return this.getFreeOrBMolecule(MoleculeSeparationPane.this.tracker.getNearestToSelectedMolecule());
        }

        public SimpleMolecule getSelectedComponentMolecule() {
            return this.getFreeOrBMolecule(MoleculeSeparationPane.this.tracker.getSelectedMolecule());
        }

        private double getDistanceBetweenTrackedMolecules() {
            return this.getSelectedComponentMolecule().getPosition().distance(this.getNearestComponentToSelectedMolecule().getPosition());
        }

        private void updatePositions() {
            if (MoleculeSeparationPane.this.tracker.isTracking()) {
                SimpleMolecule simpleMolecule = MoleculeSeparationPane.this.tracker.getFreeMolecule();
                SimpleMolecule simpleMolecule2 = MoleculeSeparationPane.this.tracker.getBoundMolecule();
                double d = this.getDistanceBetweenTrackedMolecules();
                A_BC_AB_C_Reaction a_BC_AB_C_Reaction = (A_BC_AB_C_Reaction)this.module.getMRModel().getReaction();
                double d2 = a_BC_AB_C_Reaction.getDistanceToCollision(simpleMolecule, simpleMolecule2.getParentComposite());
                if (Double.isNaN(d2)) {
                    d2 = 0.0;
                }
                double d3 = 80.0;
                double d4 = 35.0;
                double d5 = 20.0;
                double d6 = Math.min(MoleculeSeparationPane.this.tracker.getSelectedMolecule().getRadius(), MoleculeSeparationPane.this.tracker.getNearestToSelectedMolecule().getRadius());
                double d7 = a_BC_AB_C_Reaction.getEnergyProfile().getThresholdWidth() / 2.0 / d6;
                double d8 = A_BC_AB_C_Reaction.getReactionOffset(simpleMolecule, simpleMolecule2);
                double d9 = simpleMolecule.getPosition().distance(simpleMolecule2.getPosition());
                double d10 = d6 - d9;
                double d11 = d6 - d8;
                double d12 = d10 / d11 * d7;
                double d13 = Math.max((d2 + d6) * d7, d12);
                double d14 = Math.min(MoleculeSeparationPane.this.curvePane.getCurveAreaSize().getWidth() / 2.0 - d5, d13);
                double d15 = MoleculeSeparationPane.this.curvePane.getCurveAreaSize().getWidth() / 2.0 + d14 * (double)this.direction;
                double d16 = d4 + d3 / 2.0;
                if (this.direction < 0) {
                    double d17 = MoleculeSeparationPane.this.curvePane.getIntersectionWithHorizontal(d15);
                    d15 = Math.min(d15, d17);
                }
                this.midPoint = new Point2D.Double(d15, d16);
                this.yMin = this.midPoint.getY() - Math.min(d, d3) / 2.0;
                this.yMax = this.midPoint.getY() + Math.min(d, d3) / 2.0;
            }
        }
    }

    private class UpdatingClockListener
    extends ClockAdapter {
        private UpdatingClockListener() {
        }

        public void clockTicked(ClockEvent clockEvent) {
            MoleculeSeparationPane.this.update();
        }
    }
}

