/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.energy;

import edu.colorado.phet.common.piccolophet.services.PNodeShowHideControl;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.util.Resetable;
import edu.colorado.phet.reactionsandrates.view.ReactionGraphic;
import edu.colorado.phet.reactionsandrates.view.energy.CurvePane;
import edu.colorado.phet.reactionsandrates.view.energy.MoleculeSeparationPane;
import edu.colorado.phet.reactionsandrates.view.energy.UpperEnergyPane;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

public class EnergyView
extends PNode
implements Resetable {
    private volatile MoleculeSeparationPane moleculeSeparationPane;
    private volatile UpperEnergyPane upperPane;
    private volatile CurvePane curvePane;
    private volatile PPath legendNode;
    private volatile MRModule module;
    private volatile PNodeShowHideControl curvePaneCloser;
    private volatile PNodeShowHideControl moleculeSeparationCloser;
    private volatile PNode upperPaneContent;

    public void initialize(MRModule mRModule, Dimension dimension) {
        this.module = mRModule;
        this.removeAllChildren();
        this.addCurvePane(mRModule, dimension);
        this.addUpperPane(dimension);
        this.addMolecularSeparationPane(mRModule, dimension);
        this.addLegend(dimension, mRModule);
        this.addEnergyViewBorder();
    }

    private void addEnergyViewBorder() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.curvePane.getFullBounds().getWidth(), this.curvePane.getFullBounds().getHeight() + this.legendNode.getFullBounds().getHeight());
        PPath pPath = new PPath(double_);
        pPath.setOffset(this.curvePane.getOffset());
        this.addChild(pPath);
    }

    private void addLegend(Dimension dimension, MRModule mRModule) {
        MRModel mRModel = mRModule.getMRModel();
        this.legendNode = new PPath(new Rectangle2D.Double(0.0, 0.0, MRConfig.ENERGY_VIEW_REACTION_LEGEND_SIZE.width, MRConfig.ENERGY_VIEW_REACTION_LEGEND_SIZE.height));
        this.legendNode.setPaint(MRConfig.ENERGY_PANE_BACKGROUND);
        this.legendNode.setStrokePaint(new Color(0, 0, 0, 0));
        this.legendNode.setOffset(0.0, dimension.getHeight() + this.curvePane.getSize().getHeight());
        ReactionGraphic reactionGraphic = new ReactionGraphic(mRModel.getReaction(), MRConfig.ENERGY_PANE_TEXT_COLOR, mRModule.getMRModel());
        this.legendNode.addChild(reactionGraphic);
        reactionGraphic.setOffset(this.legendNode.getWidth() / 2.0, this.legendNode.getHeight() - 20.0);
        this.addChild(this.legendNode);
    }

    private void addMolecularSeparationPane(MRModule mRModule, Dimension dimension) {
        this.removeUpperPaneCloser();
        if (this.moleculeSeparationPane != null) {
            this.moleculeSeparationPane.terminate();
        }
        this.moleculeSeparationPane = new MoleculeSeparationPane(mRModule, dimension, this.curvePane);
        this.addChild(this.moleculeSeparationPane);
        this.addUpperPaneCloser();
    }

    private void removeMolecularSeparationPane() {
        this.removeUpperPaneCloser();
        if (this.moleculeSeparationPane != null) {
            if (this.getChildrenReference().contains(this.moleculeSeparationPane)) {
                this.removeChild(this.moleculeSeparationPane);
            }
            this.moleculeSeparationPane.terminate();
            this.moleculeSeparationPane = null;
        }
    }

    private void addUpperPaneCloser() {
        if (this.moleculeSeparationCloser == null) {
            this.moleculeSeparationCloser = new PNodeShowHideControl(this.moleculeSeparationPane, MRConfig.RESOURCES.getLocalizedString("SeparationView.restoreViewName"));
        }
    }

    private void removeUpperPaneCloser() {
        if (this.moleculeSeparationCloser != null) {
            this.moleculeSeparationCloser.uninstall();
            this.moleculeSeparationCloser = null;
        }
    }

    private void addUpperPane(Dimension dimension) {
        this.upperPane = new UpperEnergyPane(dimension);
        this.addChild(this.upperPane);
    }

    private void addCurvePane(MRModule mRModule, Dimension dimension) {
        this.disableCurvePaneCloser();
        if (this.curvePane != null) {
            this.curvePane.terminate();
        }
        this.curvePane = new CurvePane(mRModule, dimension);
        this.addChild(this.curvePane);
        this.enableCurvePaneCloser();
    }

    private void enableCurvePaneCloser() {
        if (this.curvePaneCloser == null) {
            this.curvePaneCloser = new PNodeShowHideControl(this.curvePane, MRConfig.RESOURCES.getLocalizedString("EnergyView.restoreViewName"));
        }
    }

    private void disableCurvePaneCloser() {
        if (this.curvePaneCloser != null) {
            this.curvePaneCloser.uninstall();
            this.curvePaneCloser = null;
        }
    }

    public void reset() {
        if (this.upperPane == null) {
            throw new InternalError();
        }
    }

    public Dimension getUpperPaneSize() {
        return this.upperPane.getSize();
    }

    public void setUpperPaneContent(PNode pNode) {
        this.clearUpperPaneContent();
        this.upperPane.addChild(pNode);
        this.upperPaneContent = pNode;
        this.upperPaneContent.setVisible(true);
        this.upperPane.setVisible(true);
    }

    public void clearUpperPaneContent() {
        this.clearUpperPaneContent(this.getUpperPaneContent());
    }

    public void clearUpperPaneContent(PNode pNode) {
        this.removeMolecularSeparationPane();
        if (pNode != null && this.upperPane.getChildrenReference().contains(pNode)) {
            this.upperPane.removeChild(this.upperPaneContent);
            this.upperPane.setVisible(false);
            this.upperPaneContent = null;
        }
    }

    public void setSeparationViewVisible(boolean bl) {
        if (bl) {
            this.moleculeSeparationCloser.show();
        } else {
            this.moleculeSeparationCloser.hide();
        }
    }

    public void setEnergyViewVisible(boolean bl) {
        if (bl) {
            this.curvePaneCloser.show();
        } else {
            this.curvePaneCloser.hide();
        }
    }

    public void setEnergyLineLabel(String string) {
        this.curvePane.setEnergyLineLabel(string);
    }

    public void setProfileManipulable(boolean bl) {
        this.curvePane.setProfileManipulable(bl);
    }

    public PNode getUpperPaneContent() {
        return this.upperPaneContent;
    }
}

