/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.energy;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeEvent;

class EnergyProfileGraphic
extends PNode {
    public static final BasicStroke LINE_STROKE = new BasicStroke(3.0f);
    private double peakLevel;
    private double modelToViewScale;
    private PPath leftFloor;
    private PPath rightFloor;
    private PPath centralCurve;
    double x1;
    double x2;
    double x3;
    double peakGrabTolerance = 10.0;
    private EnergyProfile energyProfile;
    private Dimension size;
    private boolean manipulable;
    private PNode leftFloorMouseIndicator;
    private PNode rightFloorMouseIndicator;
    private PNode centralMouseIndicator;
    private PText potentialEnergyLegend;

    EnergyProfileGraphic(EnergyProfile energyProfile, Dimension dimension, Color color) {
        this.energyProfile = energyProfile;
        this.modelToViewScale = dimension.getHeight() / MRConfig.MAX_REACTION_THRESHOLD;
        this.size = dimension;
        energyProfile.addChangeListener(new EnergyProfileChangeListener());
        double d = dimension.getWidth();
        this.x2 = d * 0.5;
        this.x1 = this.x2 - energyProfile.getThresholdWidth() / 2.0;
        this.x3 = this.x2 + energyProfile.getThresholdWidth() / 2.0;
        this.leftFloor = new PPath();
        this.leftFloor.setPathTo(new Line2D.Double(0.0, 0.0, this.x1, 0.0));
        this.addChild(this.leftFloor);
        this.leftFloor.setStrokePaint(color);
        this.leftFloor.setStroke(LINE_STROKE);
        this.leftFloor.addInputEventListener(new FloorMouseHandler(this.leftFloor));
        this.rightFloor = new PPath();
        this.rightFloor.setPathTo(new Line2D.Double(this.x3, 0.0, d, 0.0));
        this.addChild(this.rightFloor);
        this.rightFloor.setStrokePaint(color);
        this.rightFloor.setStroke(LINE_STROKE);
        this.rightFloor.addInputEventListener(new FloorMouseHandler(this.rightFloor));
        this.centralCurve = new PPath();
        this.addChild(this.centralCurve);
        this.centralCurve.setStrokePaint(color);
        this.centralCurve.setStroke(LINE_STROKE);
        this.centralCurve.addInputEventListener(new PeakMouseHandler(this.x2 - 5.0, this.x2 + 5.0));
        this.createMouseIndicatorArrows();
        PhetFont phetFont = new PhetFont(PhetFont.getDefaultFontSize() + 1, true);
        this.potentialEnergyLegend = new PText(MRConfig.RESOURCES.getLocalizedString("EnergyView.Legend.potentialEnergy"));
        this.potentialEnergyLegend.setFont(phetFont);
        this.potentialEnergyLegend.setTextPaint(MRConfig.POTENTIAL_ENERGY_COLOR);
        this.addChild(this.potentialEnergyLegend);
        this.update(energyProfile);
    }

    public double getIntersectionWithHorizontal(double d, double d2) {
        double[] dArray = new double[6];
        GeneralPath generalPath = this.centralCurve.getPathReference();
        PathIterator pathIterator = generalPath.getPathIterator(null, 0.5);
        double d3 = 0.0;
        double d4 = 0.0;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                d3 = dArray[0];
                d4 = dArray[1];
            } else if (n == 1) {
                double d5 = dArray[0];
                double d6 = dArray[1];
                double d7 = d3 + (d5 - d3) / 2.0;
                Line2D.Double double_ = new Line2D.Double(d3, d4, d5, d6);
                if (double_.getBounds().contains(d7, d)) {
                    return d7;
                }
                d3 = d5;
                d4 = d6;
            } else assert (n == 4);
            pathIterator.next();
        }
        return d2;
    }

    private void createMouseIndicatorArrows() {
        double d = 10.0;
        double d2 = 6.0;
        double d3 = 8.0;
        double d4 = 2.0;
        Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, d), d2, d3, d4);
        Arrow arrow2 = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, -d), d2, d3, d4);
        GeneralPath generalPath = arrow.getShape();
        generalPath.append(arrow2.getShape(), false);
        this.leftFloorMouseIndicator = this.createMouseIndicatorNode(generalPath);
        this.rightFloorMouseIndicator = this.createMouseIndicatorNode(generalPath);
        this.centralMouseIndicator = this.createMouseIndicatorNode(generalPath);
    }

    private PNode createMouseIndicatorNode(GeneralPath generalPath) {
        PPath pPath = new PPath(generalPath);
        pPath.setStrokePaint(MRConfig.ENERGY_PANE_TEXT_COLOR);
        this.addChild(pPath);
        pPath.setPickable(false);
        pPath.setVisible(false);
        return pPath;
    }

    private void update(EnergyProfile energyProfile) {
        this.leftFloor.setOffset(this.leftFloor.getOffset().getX(), this.size.getHeight() - energyProfile.getLeftLevel() * this.modelToViewScale);
        this.rightFloor.setOffset(this.rightFloor.getOffset().getX(), this.size.getHeight() - energyProfile.getRightLevel() * this.modelToViewScale);
        this.peakLevel = this.size.getHeight() - energyProfile.getPeakLevel() * this.modelToViewScale;
        this.leftFloorMouseIndicator.setOffset(this.x1 / 2.0, this.leftFloor.getOffset().getY());
        this.rightFloorMouseIndicator.setOffset(this.x3 + this.x1 / 2.0, this.rightFloor.getOffset().getY());
        this.centralMouseIndicator.setOffset(this.x2, this.peakLevel);
        this.potentialEnergyLegend.setOffset(this.x3 + this.x1 - this.potentialEnergyLegend.getFullBounds().getWidth(), this.rightFloor.getOffset().getY() + 5.0);
        this.updateCentralCurve();
    }

    private void updateCentralCurve() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d = this.leftFloor.getOffset().getY();
        double d2 = this.rightFloor.getOffset().getY();
        doubleGeneralPath.moveTo(this.x1, d);
        doubleGeneralPath.curveTo(this.x1 + (this.x2 - this.x1) * 0.33, d, this.x1 + (this.x2 - this.x1) * 0.66, this.peakLevel, this.x2, this.peakLevel);
        doubleGeneralPath.curveTo(this.x2 + (this.x3 - this.x2) * 0.33, this.peakLevel, this.x2 + (this.x3 - this.x2) * 0.66, d2, this.x3, d2);
        this.centralCurve.setPathTo(doubleGeneralPath.getGeneralPath());
    }

    public void setManipulable(boolean bl) {
        this.manipulable = bl;
        this.leftFloorMouseIndicator.setVisible(bl);
        this.rightFloorMouseIndicator.setVisible(bl);
        this.centralMouseIndicator.setVisible(bl);
    }

    private void constrainPeak() {
        double d = this.energyProfile.getPeakLevel();
        double d2 = Math.max(this.energyProfile.getRightLevel(), this.energyProfile.getLeftLevel());
        this.energyProfile.setPeakLevel(Math.max(d, d2));
    }

    private class EnergyProfileChangeListener
    implements EnergyProfile.ChangeListener {
        private EnergyProfileChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            EnergyProfile energyProfile = (EnergyProfile)changeEvent.getSource();
            EnergyProfileGraphic.this.update(energyProfile);
        }
    }

    private class FloorMouseHandler
    extends PBasicInputEventHandler {
        PNode pNode;

        public FloorMouseHandler(PNode pNode) {
            this.pNode = pNode;
        }

        public void mouseEntered(PInputEvent pInputEvent) {
            if (EnergyProfileGraphic.this.manipulable) {
                PhetPCanvas phetPCanvas = (PhetPCanvas)pInputEvent.getComponent();
                phetPCanvas.setCursor(new Cursor(8));
            }
        }

        public void mouseExited(PInputEvent pInputEvent) {
            PhetPCanvas phetPCanvas = (PhetPCanvas)pInputEvent.getComponent();
            phetPCanvas.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            double d = pInputEvent.getPositionRelativeTo(EnergyProfileGraphic.this.centralCurve.getParent()).getY();
            if (d >= 0.0 && d <= (double)((EnergyProfileGraphic)EnergyProfileGraphic.this).size.height && EnergyProfileGraphic.this.manipulable) {
                double d2 = pInputEvent.getDelta().getHeight();
                double d3 = pInputEvent.getPositionRelativeTo(EnergyProfileGraphic.this.centralCurve.getParent()).getX();
                if (d3 <= EnergyProfileGraphic.this.x1) {
                    double d4 = Math.min((double)((EnergyProfileGraphic)EnergyProfileGraphic.this).size.height / EnergyProfileGraphic.this.modelToViewScale, Math.max(0.0, EnergyProfileGraphic.this.energyProfile.getLeftLevel() - d2 / EnergyProfileGraphic.this.modelToViewScale));
                    EnergyProfileGraphic.this.energyProfile.setLeftLevel(d4);
                } else if (d3 >= EnergyProfileGraphic.this.x3) {
                    double d5 = Math.min((double)((EnergyProfileGraphic)EnergyProfileGraphic.this).size.height / EnergyProfileGraphic.this.modelToViewScale, Math.max(0.0, EnergyProfileGraphic.this.energyProfile.getRightLevel() - d2 / EnergyProfileGraphic.this.modelToViewScale));
                    EnergyProfileGraphic.this.energyProfile.setRightLevel(d5);
                }
                EnergyProfileGraphic.this.constrainPeak();
            }
        }
    }

    private class PeakMouseHandler
    extends PBasicInputEventHandler {
        private double xMin;
        private double xMax;

        public PeakMouseHandler(double d, double d2) {
            this.xMin = d;
            this.xMax = d2;
        }

        public void mouseEntered(PInputEvent pInputEvent) {
            double d = pInputEvent.getPositionRelativeTo(EnergyProfileGraphic.this.centralCurve.getParent()).getX();
            if (d >= this.xMin && d <= this.xMax && EnergyProfileGraphic.this.manipulable) {
                PhetPCanvas phetPCanvas = (PhetPCanvas)pInputEvent.getComponent();
                phetPCanvas.setCursor(new Cursor(8));
            }
        }

        public void mouseExited(PInputEvent pInputEvent) {
            PhetPCanvas phetPCanvas = (PhetPCanvas)pInputEvent.getComponent();
            phetPCanvas.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            double d = pInputEvent.getPositionRelativeTo(EnergyProfileGraphic.this.centralCurve.getParent()).getY();
            if (d >= 0.0 && d <= (double)((EnergyProfileGraphic)EnergyProfileGraphic.this).size.height && EnergyProfileGraphic.this.manipulable) {
                double d2 = pInputEvent.getDelta().getHeight();
                double d3 = Math.min((double)((EnergyProfileGraphic)EnergyProfileGraphic.this).size.height / EnergyProfileGraphic.this.modelToViewScale, Math.max(0.0, EnergyProfileGraphic.this.energyProfile.getPeakLevel() - d2 / EnergyProfileGraphic.this.modelToViewScale));
                EnergyProfileGraphic.this.energyProfile.setPeakLevel(d3);
                EnergyProfileGraphic.this.constrainPeak();
            }
        }
    }
}

