/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.energy;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.util.Resetable;
import edu.colorado.phet.reactionsandrates.view.energy.EnergyProfileGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class EnergyLine
extends PNode
implements Resetable {
    public static final Paint linePaint = MRConfig.TOTAL_ENERGY_COLOR;
    public static final Stroke lineStroke = new BasicStroke(EnergyProfileGraphic.LINE_STROKE.getLineWidth() + 1.0f);
    private Line2D line;
    private PPath lineNode;
    private Dimension bounds;
    private MRModel model;
    private double scale;
    private PText totalEnergyLegend;
    private MRModule module;
    private double curEnergy = -1.0;

    public EnergyLine(Dimension dimension, MRModule mRModule, IClock iClock) {
        this.module = mRModule;
        this.bounds = dimension;
        this.model = mRModule.getMRModel();
        this.line = new Line2D.Double();
        this.lineNode = new PPath(this.line);
        this.lineNode.setPaint(linePaint);
        this.lineNode.setStroke(lineStroke);
        this.lineNode.setStrokePaint(linePaint);
        this.scale = dimension.getHeight() / MRConfig.MAX_REACTION_THRESHOLD;
        this.addChild(this.lineNode);
        PhetFont phetFont = new PhetFont(PhetFont.getDefaultFontSize() + 1, true);
        this.totalEnergyLegend = new PText(MRConfig.RESOURCES.getLocalizedString("EnergyView.Legend.totalEnergy"));
        this.totalEnergyLegend.setFont(phetFont);
        this.totalEnergyLegend.setTextPaint(MRConfig.TOTAL_ENERGY_COLOR);
        this.addChild(this.totalEnergyLegend);
        iClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                EnergyLine.this.update();
            }
        });
        this.model.addListener(new MRModel.ModelListenerAdapter(){

            public void notifyDefaultTemperatureChanged(double d) {
                EnergyLine.this.update();
            }
        });
        this.setChildrenPickable(false);
        this.setPickable(false);
        this.curEnergy = this.model.getTotalEnergy();
    }

    public double getEnergyLineY() {
        return this.line.getY1();
    }

    public void reset() {
        this.curEnergy = -1.0;
    }

    public void update() {
        if (this.module.isTemperatureBeingAdjusted() || this.module.isResetInProgress() || this.curEnergy < 0.0) {
            this.curEnergy = this.model.getTotalEnergy();
        }
        double d = Math.max(this.bounds.getHeight() - this.curEnergy * this.scale, 0.0);
        this.line.setLine(0.0, d, this.bounds.getWidth(), d);
        this.lineNode.setPathTo(this.line);
        this.totalEnergyLegend.setOffset(5.0, d + 5.0);
    }

    public void setLabel(String string) {
        this.totalEnergyLegend.setText(MRConfig.RESOURCES.getLocalizedString(string));
    }
}

