/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.charts;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.util.Resetable;
import edu.colorado.phet.reactionsandrates.view.charts.AbstractRescaleableChartNode;
import edu.colorado.phet.reactionsandrates.view.charts.MoleculePopulationsStripChart;
import edu.colorado.phet.reactionsandrates.view.charts.StripChart;
import edu.colorado.phet.reactionsandrates.view.charts.StripChartAdjuster;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import org.jfree.chart.ChartPanel;

public class StripChartNode
extends AbstractRescaleableChartNode
implements Resetable {
    private MoleculePopulationsStripChart stripChart;
    private IClock clock;

    public StripChartNode(MRModule mRModule, Dimension dimension) {
        PhetPCanvas phetPCanvas = new PhetPCanvas();
        this.clock = mRModule.getClock();
        Insets insets = new Insets(3, 80, 3, 10);
        int n = MRConfig.STRIP_CHART_BUFFER_SIZE;
        this.stripChart = new MoleculePopulationsStripChart(mRModule.getMRModel(), this.clock, 300.0, 0.0, 10.0, 10.0, n);
        ChartPanel chartPanel = new ChartPanel(this.stripChart.getChart());
        chartPanel.setBackground(MRConfig.MOLECULE_PANE_BACKGROUND);
        final JScrollBar jScrollBar = new JScrollBar(0, 0, (int)this.stripChart.getViewableRangeX(), 0, 300);
        jScrollBar.addAdjustmentListener(new StripChartAdjuster(this.stripChart));
        Dimension dimension2 = new Dimension((int)(dimension.getWidth() - (double)insets.left - (double)insets.right), 15);
        jScrollBar.setPreferredSize(dimension2);
        final PSwing pSwing = new PSwing(jScrollBar);
        pSwing.setPaint(new Color(0, 0, 0, 0));
        pSwing.setOffset(insets.left, dimension.getHeight() - pSwing.getFullBounds().getHeight() - (double)insets.bottom);
        chartPanel.setPreferredSize(new Dimension(dimension.width, dimension.height - (int)pSwing.getFullBounds().getHeight() - insets.bottom - insets.top));
        final PSwing pSwing2 = new PSwing(chartPanel);
        phetPCanvas.addScreenChild(pSwing2);
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                pSwing.repaint();
                pSwing2.repaint();
            }
        });
        jScrollBar.setVisible(true);
        jScrollBar.setEnabled(true);
        this.addZoomControl(dimension, phetPCanvas, this.stripChart);
        phetPCanvas.setOpaque(true);
        phetPCanvas.addScreenChild(pSwing);
        this.stripChart.addListener(new StripChart.Listener(){

            public void dataChanged() {
                jScrollBar.setMaximum((int)Math.max(StripChartNode.this.stripChart.getMaxX(), 300.0));
                jScrollBar.setMinimum((int)StripChartNode.this.stripChart.getMinX());
                jScrollBar.setVisibleAmount((int)StripChartNode.this.stripChart.getViewableRangeX());
                jScrollBar.setValue((int)StripChartNode.this.stripChart.getMaxX());
            }
        });
        this.addChild(phetPCanvas.getPhetRootNode());
    }

    public void setRecording(boolean bl) {
        if (this.stripChart.isRecording() != bl) {
            if (bl) {
                this.stripChart.startRecording(this.clock.getSimulationTime());
            } else {
                this.stripChart.stopRecording();
            }
        }
    }

    public void reset() {
        this.stripChart.reset();
        this.repaint();
    }

    public void rescale() {
        this.stripChart.rescale();
    }
}

