/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.charts;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.reactionsandrates.util.Resetable;
import edu.colorado.phet.reactionsandrates.view.charts.ResizableChart;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.EventListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;

public class StripChart
implements Resetable,
ResizableChart {
    private XYSeries[] series;
    private JFreeChart chart;
    private double xAxisRange;
    private XYLineAndShapeRenderer renderer;
    private XYPlot plot;
    private int buffSize = 2;
    private double[][] buffer;
    private int clockBufferIdx;
    private int buffHead = 0;
    private int buffTail = this.buffSize - 1;
    private boolean recording;
    private double t0;
    private EventChannel eventChannel = new EventChannel(Listener.class);
    private Listener listenerProxy = (Listener)this.eventChannel.getListenerProxy();

    public StripChart(String string, String[] stringArray, String string2, String string3, PlotOrientation plotOrientation, double d, double d2, double d3, int n) {
        int n2;
        this.xAxisRange = d;
        this.buffSize = n;
        this.buffTail = n - 1;
        this.series = new XYSeries[stringArray.length];
        this.buffer = new double[stringArray.length + 1][n];
        this.clockBufferIdx = stringArray.length;
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (n2 = 0; n2 < this.series.length; ++n2) {
            this.series[n2] = new XYSeries((Comparable)((Object)stringArray[n2]));
            xYSeriesCollection.addSeries(this.series[n2]);
        }
        this.chart = ChartFactory.createXYLineChart(string, string2, string3, xYSeriesCollection, plotOrientation, true, true, false);
        this.chart.getXYPlot().setDomainGridlinesVisible(false);
        this.chart.getXYPlot().setRangeGridlinesVisible(false);
        this.chart.getLegend().setHorizontalAlignment(HorizontalAlignment.RIGHT);
        this.plot = (XYPlot)this.chart.getPlot();
        this.plot.getRangeAxis().setRange(d2, d3);
        this.renderer = new XYLineAndShapeRenderer();
        for (n2 = 0; n2 < this.series.length; ++n2) {
            this.renderer.setSeriesLinesVisible(n2, true);
            this.renderer.setSeriesShapesVisible(n2, false);
        }
        this.renderer.setSeriesLinesVisible(this.series.length, false);
        this.renderer.setSeriesShapesVisible(this.series.length, false);
        this.renderer.setToolTipGenerator(new StandardXYToolTipGenerator());
        this.renderer.setDefaultEntityRadius(6);
        this.plot.setRenderer(this.renderer);
        this.setMinX(0.0);
    }

    public void setSeriesPaint(int n, Paint paint) {
        this.renderer.setSeriesPaint(n, paint);
    }

    public void setStroke(Stroke stroke) {
        this.renderer.setStroke(stroke);
    }

    public void addData(double d, double[] dArray) {
        if (this.recording) {
            double d2 = d - this.t0;
            for (int i = 0; i < this.series.length; ++i) {
                this.series[i].add(d2, dArray[i]);
                this.buffer[i][this.buffHead] = dArray[i];
            }
            this.buffer[this.clockBufferIdx][this.buffHead] = d2;
            XYPlot xYPlot = (XYPlot)this.chart.getPlot();
            double d3 = Math.max(this.buffer[this.clockBufferIdx][this.buffHead] - this.xAxisRange, 0.0);
            double d4 = Math.max(this.buffer[this.clockBufferIdx][this.buffHead], this.xAxisRange);
            xYPlot.getDomainAxis().setRange(d3, d4);
            this.buffHead = (this.buffHead + 1) % this.buffSize;
            if (this.buffHead == this.buffTail) {
                this.buffTail = (this.buffTail + 1) % this.buffSize;
            }
            this.listenerProxy.dataChanged();
        }
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setMinX(double d) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        double d2 = Math.max(0.0, Math.min(d, this.getMaxTime() - this.xAxisRange));
        double d3 = Math.max(this.xAxisRange, Math.min(d + this.xAxisRange, this.getMaxTime()));
        xYPlot.getDomainAxis().setRange(d2, d3);
    }

    private double getMaxTime() {
        int n = (this.buffHead + this.buffSize - 1) % this.buffSize;
        return this.buffer[this.clockBufferIdx][n];
    }

    private double getMinTime() {
        return this.buffer[this.clockBufferIdx][this.buffTail];
    }

    public void setYRange(int n, int n2) {
        this.plot.getRangeAxis().setRange(n, n2);
    }

    public Range getYRange() {
        return this.plot.getRangeAxis().getRange();
    }

    public double getMaxX() {
        return this.getMaxTime();
    }

    public double getMinX() {
        return this.getMinTime();
    }

    public double getViewableRangeX() {
        Range range = this.getChart().getXYPlot().getDomainAxis().getRange();
        return range.getLength();
    }

    public void startRecording(double d) {
        this.recording = true;
        this.t0 = d;
    }

    public void stopRecording() {
        this.recording = false;
    }

    public void reset() {
        this.recording = false;
        this.buffHead = 0;
        this.buffTail = this.buffSize - 1;
        for (int i = 0; i < this.series.length; ++i) {
            this.series[i].clear();
        }
        this.setMinX(0.0);
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void addListener(Listener listener) {
        this.eventChannel.addListener(listener);
    }

    public static interface Listener
    extends EventListener {
        public void dataChanged();
    }
}

