/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.charts;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.MoleculeCounter;
import edu.colorado.phet.reactionsandrates.view.MoleculePaints;
import edu.colorado.phet.reactionsandrates.view.charts.StripChart;
import java.awt.BasicStroke;
import org.jfree.chart.plot.PlotOrientation;

public class MoleculePopulationsStripChart
extends StripChart {
    static String title = MRConfig.RESOURCES.getLocalizedString("StripChart.title");
    static String[] seriesNames = new String[]{"A", "BC", "AB", "C"};
    static String xAxisLabel = MRConfig.RESOURCES.getLocalizedString("StripChart.time");
    static String yAxisLabel = MRConfig.RESOURCES.getLocalizedString("StripChart.num");
    static PlotOrientation orienation = PlotOrientation.VERTICAL;
    private MoleculeCounter counterA;
    private MoleculeCounter counterAB;
    private MoleculeCounter counterBC;
    private MoleculeCounter counterC;
    private double updateInterval;
    private double timeSinceLastUpdate;
    private Updater updater;
    private IClock clock;

    public MoleculePopulationsStripChart(MRModel mRModel, IClock iClock, double d, double d2, double d3, double d4, int n) {
        super(title, seriesNames, xAxisLabel, yAxisLabel, orienation, d, d2, d3, n);
        this.clock = iClock;
        this.getChart().setBackgroundPaint(MRConfig.MOLECULE_PANE_BACKGROUND);
        this.updateInterval = d4;
        this.counterA = new MoleculeCounter(MoleculeA.class, mRModel);
        this.counterAB = new MoleculeCounter(MoleculeAB.class, mRModel);
        this.counterBC = new MoleculeCounter(MoleculeBC.class, mRModel);
        this.counterC = new MoleculeCounter(MoleculeC.class, mRModel);
        this.setStroke(new BasicStroke(2.0f));
        EnergyProfile energyProfile = mRModel.getEnergyProfile();
        this.setPaintOfMolecules(energyProfile);
        mRModel.addListener(new MRModel.ModelListenerAdapter(){

            public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
                MoleculePopulationsStripChart.this.setPaintOfMolecules(energyProfile);
            }
        });
        this.updater = new Updater();
        iClock.addClockListener(this.updater);
    }

    private void setPaintOfMolecules(EnergyProfile energyProfile) {
        this.setSeriesPaint(0, MoleculePaints.getPaint(MoleculeA.class, energyProfile));
        this.setSeriesPaint(1, MoleculePaints.getPaint(MoleculeBC.class, energyProfile));
        this.setSeriesPaint(2, MoleculePaints.getPaint(MoleculeAB.class, energyProfile));
        this.setSeriesPaint(3, MoleculePaints.getPaint(MoleculeC.class, energyProfile));
    }

    public void rescale() {
        int n = 10;
        n = Math.max(n, this.counterA.getCnt());
        n = Math.max(n, this.counterBC.getCnt());
        n = Math.max(n, this.counterAB.getCnt());
        n = Math.max(n, this.counterC.getCnt());
        super.setYRange(0, (int)((double)n * 1.5));
    }

    private class Updater
    extends ClockAdapter {
        private Updater() {
        }

        public void clockTicked(ClockEvent clockEvent) {
            MoleculePopulationsStripChart.this.timeSinceLastUpdate += clockEvent.getSimulationTimeChange();
            if (MoleculePopulationsStripChart.this.timeSinceLastUpdate > MoleculePopulationsStripChart.this.updateInterval) {
                MoleculePopulationsStripChart.this.timeSinceLastUpdate = 0.0;
                MoleculePopulationsStripChart.this.addData(clockEvent.getSimulationTime(), new double[]{MoleculePopulationsStripChart.this.counterA.getCnt(), MoleculePopulationsStripChart.this.counterBC.getCnt(), MoleculePopulationsStripChart.this.counterAB.getCnt(), MoleculePopulationsStripChart.this.counterC.getCnt(), MoleculePopulationsStripChart.this.counterA.getCnt()});
            }
        }
    }
}

