/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.charts;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.MoleculeCounter;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.view.MoleculePaints;
import edu.colorado.phet.reactionsandrates.view.charts.PieChartNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MoleculePopulationsPieChart
extends PieChartNode {
    private double updateInterval;
    private double timeSinceLastUpdate;
    private PieChartNode.PieValue[] values = new PieChartNode.PieValue[]{new PieChartNode.PieValue(), new PieChartNode.PieValue(), new PieChartNode.PieValue(), new PieChartNode.PieValue()};
    private MoleculeCounter counterA;
    private MoleculeCounter counterAB;
    private MoleculeCounter counterBC;
    private MoleculeCounter counterC;
    private Rectangle currentSize = new Rectangle();
    private Point2D pieCenter;
    private Insets insets = new Insets(25, 15, 25, 15);

    public MoleculePopulationsPieChart(MRModule mRModule, Rectangle2D rectangle2D, double d) {
        super(new Rectangle());
        this.setBounds(rectangle2D);
        PText pText = new PText(MRConfig.RESOURCES.getLocalizedString("StripChart.title"));
        this.addChild(pText);
        this.pieCenter = new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        this.updateInterval = d;
        this.setPaintsForProfile(mRModule.getMRModel().getEnergyProfile());
        mRModule.getMRModel().addListener(new MRModel.ModelListenerAdapter(){

            public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
                MoleculePopulationsPieChart.this.setPaintsForProfile(energyProfile);
            }
        });
        this.counterA = new MoleculeCounter(MoleculeA.class, mRModule.getMRModel());
        this.counterAB = new MoleculeCounter(MoleculeAB.class, mRModule.getMRModel());
        this.counterBC = new MoleculeCounter(MoleculeBC.class, mRModule.getMRModel());
        this.counterC = new MoleculeCounter(MoleculeC.class, mRModule.getMRModel());
        mRModule.getClock().addClockListener(new PieChartUpdater());
        this.update();
    }

    private void setPaintsForProfile(EnergyProfile energyProfile) {
        this.values[0].setPaint(MoleculePaints.getPaint(MoleculeA.class, energyProfile));
        this.values[1].setPaint(MoleculePaints.getPaint(MoleculeBC.class, energyProfile));
        this.values[2].setPaint(MoleculePaints.getPaint(MoleculeC.class, energyProfile));
        this.values[3].setPaint(MoleculePaints.getPaint(MoleculeAB.class, energyProfile));
        this.setPieValues(this.values);
    }

    private void update() {
        this.values[0].setValue(this.counterA.getCnt());
        this.values[1].setValue(this.counterBC.getCnt());
        this.values[2].setValue(this.counterC.getCnt());
        this.values[3].setValue(this.counterAB.getCnt());
        int n = this.counterA.getCnt() + this.counterBC.getCnt() + this.counterAB.getCnt() + this.counterC.getCnt();
        double d = Math.min(this.getBounds().getHeight() - (double)this.insets.top - (double)this.insets.bottom, this.getBounds().getWidth() - (double)this.insets.left - (double)this.insets.right);
        double d2 = Math.max(4.0, Math.min(d, (double)(n * 3)));
        this.currentSize.setFrameFromCenter(this.pieCenter.getX(), this.pieCenter.getY(), this.pieCenter.getX() - d2 / 2.0, this.pieCenter.getY() - d2 / 2.0);
        this.setArea(this.currentSize);
        this.setPieValues(this.values);
    }

    private class PieChartUpdater
    extends ClockAdapter {
        private PieChartUpdater() {
        }

        public void clockTicked(ClockEvent clockEvent) {
            MoleculePopulationsPieChart.this.timeSinceLastUpdate += clockEvent.getSimulationTimeChange();
            if (MoleculePopulationsPieChart.this.timeSinceLastUpdate > MoleculePopulationsPieChart.this.updateInterval) {
                MoleculePopulationsPieChart.this.timeSinceLastUpdate = 0.0;
                MoleculePopulationsPieChart.this.update();
            }
        }
    }
}

