/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.charts;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.modules.ComplexModule;
import edu.colorado.phet.reactionsandrates.view.charts.AbstractRescaleableChartNode;
import edu.colorado.phet.reactionsandrates.view.charts.MoleculePopulationsBarChart;
import edu.colorado.phet.reactionsandrates.view.icons.MoleculeIcon;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import org.jfree.chart.ChartPanel;

public class MoleculePopulationsBarChartNode
extends AbstractRescaleableChartNode {
    private final MoleculePopulationsBarChart barChart;
    private final PImage mANode = new PImage();
    private final PImage mBCNode = new PImage();
    private final PImage mABNode = new PImage();
    private final PImage mCNode = new PImage();

    public MoleculePopulationsBarChartNode(ComplexModule complexModule, Dimension dimension, PhetPCanvas phetPCanvas) {
        PhetPCanvas phetPCanvas2 = new PhetPCanvas();
        this.barChart = new MoleculePopulationsBarChart(complexModule.getMRModel(), complexModule.getClock(), 0, 20, 1.0);
        ChartPanel chartPanel = new ChartPanel(this.barChart.getChart());
        Insets insets = new Insets(0, 10, 0, 0);
        chartPanel.setPreferredSize(new Dimension((int)dimension.getWidth() - insets.left + insets.right, (int)(dimension.getHeight() - 40.0)));
        PSwing pSwing = new PSwing(chartPanel);
        pSwing.setOffset(insets.left, 0.0);
        phetPCanvas2.addScreenChild(pSwing);
        this.updateLegendGraphics(complexModule.getMRModel().getEnergyProfile());
        complexModule.getMRModel().addListener(new MRModel.ModelListenerAdapter(){

            public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
                MoleculePopulationsBarChartNode.this.updateLegendGraphics(energyProfile);
            }
        });
        phetPCanvas2.addScreenChild(this.mANode);
        phetPCanvas2.addScreenChild(this.mBCNode);
        phetPCanvas2.addScreenChild(this.mABNode);
        phetPCanvas2.addScreenChild(this.mCNode);
        phetPCanvas2.addScreenChild(new PPath(new Rectangle(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight())));
        double d = pSwing.getFullBounds().getHeight() + 18.0;
        double d2 = 58.0;
        double d3 = 84 + insets.left;
        this.mANode.setOffset(d3 - this.mANode.getFullBounds().getWidth() / 2.0, d - this.mANode.getFullBounds().getHeight() / 2.0);
        this.mBCNode.setOffset((d3 += d2) - this.mBCNode.getFullBounds().getWidth() / 2.0, d - this.mBCNode.getFullBounds().getHeight() / 2.0);
        this.mABNode.setOffset((d3 += d2) - this.mABNode.getFullBounds().getWidth() / 2.0, d - this.mABNode.getFullBounds().getHeight() / 2.0);
        this.mCNode.setOffset((d3 += d2) - this.mCNode.getFullBounds().getWidth() / 2.0, d - this.mCNode.getFullBounds().getHeight() / 2.0);
        this.addZoomControl(dimension, phetPCanvas2, this.barChart);
        phetPCanvas2.setOpaque(true);
        this.addChild(phetPCanvas2.getPhetRootNode());
    }

    private void updateLegendGraphics(EnergyProfile energyProfile) {
        this.mANode.setImage(new MoleculeIcon(MoleculeA.class, energyProfile).getImage());
        this.mBCNode.setImage(new MoleculeIcon(MoleculeBC.class, energyProfile).getImage());
        this.mABNode.setImage(new MoleculeIcon(MoleculeAB.class, energyProfile).getImage());
        this.mCNode.setImage(new MoleculeIcon(MoleculeC.class, energyProfile).getImage());
    }

    public void rescale() {
        this.barChart.rescale();
    }
}

