/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.charts;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.MoleculeCounter;
import edu.colorado.phet.reactionsandrates.view.MoleculePaints;
import edu.colorado.phet.reactionsandrates.view.charts.BarChart;
import java.awt.BasicStroke;
import java.awt.Color;
import org.jfree.chart.plot.PlotOrientation;

public class MoleculePopulationsBarChart
extends BarChart {
    static String title = MRConfig.RESOURCES.getLocalizedString("StripChart.title");
    static String[] seriesNames = new String[]{"A", "BC", "AB", "C"};
    static String xAxisLabel = "";
    static String yAxisLabel = MRConfig.RESOURCES.getLocalizedString("StripChart.num");
    static PlotOrientation orienation = PlotOrientation.VERTICAL;
    private MoleculeCounter counterA;
    private MoleculeCounter counterAB;
    private MoleculeCounter counterBC;
    private MoleculeCounter counterC;
    private double updateInterval;
    private double timeSinceLastUpdate;

    public MoleculePopulationsBarChart(MRModel mRModel, IClock iClock, int n, int n2, double d) {
        super(title, seriesNames, xAxisLabel, yAxisLabel, orienation, n, n2, false);
        this.updateInterval = d;
        this.counterA = new MoleculeCounter(MoleculeA.class, mRModel);
        this.counterAB = new MoleculeCounter(MoleculeAB.class, mRModel);
        this.counterBC = new MoleculeCounter(MoleculeBC.class, mRModel);
        this.counterC = new MoleculeCounter(MoleculeC.class, mRModel);
        this.setChartColors(mRModel.getEnergyProfile());
        iClock.addClockListener(new Updater());
        this.updateChart();
        mRModel.addListener(new MRModel.ModelListenerAdapter(){

            public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
                MoleculePopulationsBarChart.this.setChartColors(energyProfile);
            }
        });
    }

    private void setChartColors(EnergyProfile energyProfile) {
        this.setSeriesPaint(0, MoleculePaints.getPaint(MoleculeA.class, energyProfile));
        this.setSeriesPaint(1, MoleculePaints.getPaint(MoleculeBC.class, energyProfile));
        this.setSeriesPaint(2, MoleculePaints.getPaint(MoleculeAB.class, energyProfile));
        this.setSeriesPaint(3, MoleculePaints.getPaint(MoleculeC.class, energyProfile));
        this.getChart().setBackgroundPaint(MRConfig.MOLECULE_PANE_BACKGROUND);
        this.getChart().setBorderStroke(new BasicStroke(1.0f));
        this.getChart().setBorderPaint(Color.black);
        this.getChart().getTitle().setFont(MRConfig.CHART_TITLE_FONT);
    }

    private void updateChart() {
        this.addData(this.counterA.getCnt(), seriesNames[0], "");
        this.addData(this.counterBC.getCnt(), seriesNames[1], "");
        this.addData(this.counterAB.getCnt(), seriesNames[2], "");
        this.addData(this.counterC.getCnt(), seriesNames[3], "");
    }

    public void rescale() {
        int n = 0;
        n = Math.max(n, this.counterA.getCnt());
        n = Math.max(n, this.counterBC.getCnt());
        n = Math.max(n, this.counterAB.getCnt());
        n = Math.max(n, this.counterC.getCnt());
        double d = 15.0;
        this.setYRange(0, (int)Math.max(d, (double)n * 1.5));
    }

    private class Updater
    extends ClockAdapter {
        private Updater() {
        }

        public void clockTicked(ClockEvent clockEvent) {
            MoleculePopulationsBarChart.this.timeSinceLastUpdate += clockEvent.getSimulationTimeChange();
            if (MoleculePopulationsBarChart.this.timeSinceLastUpdate >= MoleculePopulationsBarChart.this.updateInterval) {
                MoleculePopulationsBarChart.this.timeSinceLastUpdate = 0.0;
                MoleculePopulationsBarChart.this.updateChart();
            }
        }
    }
}

