/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.charts;

import edu.colorado.phet.reactionsandrates.view.charts.ResizableChart;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.DefaultCategoryDataset;

public class BarChart
implements ResizableChart {
    private JFreeChart chart;
    private BarRenderer renderer;
    private DefaultCategoryDataset dataset;

    public BarChart(String string, String[] stringArray, String string2, String string3, PlotOrientation plotOrientation, int n, int n2, boolean bl) {
        this.dataset = this.createDataset(stringArray);
        this.chart = ChartFactory.createBarChart(string, string2, string3, this.dataset, plotOrientation, bl, true, false);
        this.chart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        categoryPlot.getRangeAxis().setRange(n, n2);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.renderer = (BarRenderer)categoryPlot.getRenderer();
        this.renderer.setDrawBarOutline(false);
    }

    private DefaultCategoryDataset createDataset(String[] stringArray) {
        String string = "";
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultCategoryDataset.setValue(i, (Comparable)((Object)stringArray[i]), (Comparable)((Object)string));
        }
        return defaultCategoryDataset;
    }

    public void setSeriesPaint(int n, Paint paint) {
        this.renderer.setSeriesPaint(n, paint);
    }

    public void addData(int n, String string, String string2) {
        this.dataset.setValue(n, (Comparable)((Object)string), (Comparable)((Object)string2));
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setYRange(int n, int n2) {
        this.getChart().getCategoryPlot().getRangeAxis().setRange(n, n2);
    }

    public Range getYRange() {
        return this.getChart().getCategoryPlot().getRangeAxis().getRange();
    }
}

